/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.shape;

import brentmaas.buildguide.common.shape.IShapeBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class ShapeBuffer
implements IShapeBuffer {
    private BufferBuilder builder = new BufferBuilder(28);
    private VertexBuffer buffer;

    public ShapeBuffer() {
        this.builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
    }

    @Override
    public void setColour(int r, int g, int b, int a) {
        this.builder.defaultColor(r, g, b, a);
    }

    @Override
    public void pushVertex(double x, double y, double z) {
        this.builder.vertex(x, y, z).endVertex();
    }

    @Override
    public void end() {
        this.buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.buffer.bind();
        this.buffer.upload(this.builder.end());
        VertexBuffer.unbind();
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    public void render(Matrix4f model, Matrix4f projection) {
        this.buffer.bind();
        this.buffer.drawWithShader(model, RenderSystem.getProjectionMatrix(), GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
    }
}

