/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Config {
    private File configFile;
    public ArrayList<ConfigElement<?>> configElements = new ArrayList();
    public ConfigElement<Boolean> asyncEnabled = new BooleanConfigElement("asyncEnabled", "config.buildguide.asyncEnabled", true, "config.buildguide.asyncEnabledComment");
    public ConfigElement<Boolean> shapeListRandomColorsDefaultEnabled = new BooleanConfigElement("shapeListRandomColorsDefaultEnabled", "config.buildguide.shapeListRandomColorsDefaultEnabled", false, "config.buildguide.shapeListRandomColorsDefaultEnabledComment");
    public ConfigElement<Boolean> persistenceEnabled = new BooleanConfigElement("persistenceEnabled", "config.buildguide.persistenceEnabled", false, "config.buildguide.persistenceEnabledComment");

    public Config(File configFolder) {
        this.configFile = new File(configFolder, "buildguide.cfg");
        this.configElements.add(this.asyncEnabled);
        this.configElements.add(this.shapeListRandomColorsDefaultEnabled);
        this.configElements.add(this.persistenceEnabled);
        if (!this.configFile.exists()) {
            this.write();
        } else {
            this.load();
        }
    }

    public void write() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));
            for (ConfigElement<?> element : this.configElements) {
                if (element.commentTranslationKey != null) {
                    writer.write("# " + String.valueOf(new AbstractScreenHandler.Translatable(element.commentTranslationKey, new Object[0])) + "\n");
                }
                writer.write(element.key + " = " + String.valueOf(element.value) + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            String line;
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                String[] split = line.split(" = ", 2);
                if (split.length < 2) {
                    BuildGuide.logHandler.errorOrHigher("Invalid config line: '" + line + "'");
                    continue;
                }
                keys.add(split[0]);
                values.add(split[1]);
            }
            reader.close();
            Object[] present = new Boolean[this.configElements.size()];
            Arrays.fill(present, (Object)false);
            block5: for (int i = 0; i < keys.size(); ++i) {
                for (int j = 0; j < this.configElements.size(); ++j) {
                    if (!((String)keys.get(i)).equals(this.configElements.get((int)j).key)) continue;
                    try {
                        this.configElements.get(j).setValue((String)values.get(i));
                    }
                    catch (Exception e) {
                        BuildGuide.logHandler.errorOrHigher("Could not read value '" + (String)values.get(i) + "' for config '" + (String)keys.get(j) + "', keeping '" + String.valueOf(this.configElements.get((int)j).value) + "'");
                    }
                    present[j] = true;
                    continue block5;
                }
            }
            if (Arrays.asList(present).contains(false)) {
                this.write();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class BooleanConfigElement
    extends ConfigElement<Boolean> {
        public BooleanConfigElement(String key, String translationKey, Boolean defaultValue) {
            super(key, translationKey, defaultValue);
        }

        public BooleanConfigElement(String key, String translationKey, Boolean defaultValue, String commentTranslationKey) {
            super(key, translationKey, defaultValue, commentTranslationKey);
        }

        @Override
        public void setValue(String value) {
            this.value = Boolean.parseBoolean(value);
        }
    }

    public abstract class ConfigElement<T> {
        public String key;
        public String translationKey;
        public T value;
        private T defaultValue;
        public String commentTranslationKey;

        public ConfigElement(String key, String translationKey, T defaultValue) {
            this(key, translationKey, defaultValue, null);
        }

        public ConfigElement(String key, String translationKey, T defaultValue, String commentTranslationKey) {
            this.key = key;
            this.translationKey = translationKey;
            this.value = defaultValue;
            this.defaultValue = defaultValue;
            this.commentTranslationKey = commentTranslationKey;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public abstract void setValue(String var1);
    }
}

