/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.DropdownOverlayScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import brentmaas.buildguide.common.shape.ShapeSet;

public class ShapelistScreen
extends BaseScreen {
    private AbstractScreenHandler.Translatable titleNewShape = new AbstractScreenHandler.Translatable("screen.buildguide.newshape", new Object[0]);
    private AbstractScreenHandler.Translatable titleSelectedShape = new AbstractScreenHandler.Translatable("screen.buildguide.selectedshape", new Object[0]);
    private AbstractScreenHandler.Translatable textVisible = new AbstractScreenHandler.Translatable("screen.buildguide.visible", new Object[0]);
    private AbstractScreenHandler.Translatable titleGlobalOrigin = new AbstractScreenHandler.Translatable("screen.buildguide.globalorigin", new Object[0]);
    private AbstractScreenHandler.Translatable titleShapes = new AbstractScreenHandler.Translatable("screen.buildguide.shapes", new Object[0]);
    private IShapeList shapeList;
    private DropdownOverlayScreen dropdownOverlayScreenNewShapeSelect = new DropdownOverlayScreen(this, 5, 70, 160, 20, ShapeRegistry.getTranslatables(), BuildGuide.stateManager.getState().getIShapeNew(), selected -> BuildGuide.stateManager.getState().setIShapeNew(selected));
    private IButton buttonAdd = BuildGuide.widgetHandler.createButton(5, 90, 160, 20, new AbstractScreenHandler.Translatable("screen.buildguide.add", new Object[0]), () -> {
        BuildGuide.stateManager.getState().pushNewShapeSet();
        BuildGuide.stateManager.getState().getShapeSet(BuildGuide.stateManager.getState().getNumberOfShapeSets() - 1).updateAllShapes();
        this.shapeList.addEntry(BuildGuide.stateManager.getState().getNumberOfShapeSets() - 1);
        this.checkActive();
    });
    private ICheckboxRunnableButton buttonVisible = BuildGuide.widgetHandler.createCheckbox(5, 135, new AbstractScreenHandler.Translatable("", new Object[0]), true, false, () -> this.setShapeVisibility());
    private IButton buttonDelete = BuildGuide.widgetHandler.createButton(5, 155, 160, 20, new AbstractScreenHandler.Translatable("screen.buildguide.delete", new Object[0]), () -> {
        if (this.shapeList.getSelected() != null) {
            BuildGuide.stateManager.getState().removeShapeSet(this.shapeList.getSelected().getShapeSetId());
            this.shapeList.removeEntry(this.shapeList.getSelected());
        }
        this.checkActive();
    });
    private IButton buttonGlobalOrigin = BuildGuide.widgetHandler.createButton(5, 200, 160, 20, new AbstractScreenHandler.Translatable("screen.buildguide.setglobalorigin", new Object[0]), () -> {
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            this.setGlobalOrigin();
        }
    });
    private IButton buttonOriginXDecrease = BuildGuide.widgetHandler.createButton(25, 220, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> this.shiftGlobalOrigin(-1, 0, 0));
    private IButton buttonOriginXIncrease = BuildGuide.widgetHandler.createButton(145, 220, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> this.shiftGlobalOrigin(1, 0, 0));
    private IButton buttonOriginYDecrease = BuildGuide.widgetHandler.createButton(25, 240, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> this.shiftGlobalOrigin(0, -1, 0));
    private IButton buttonOriginYIncrease = BuildGuide.widgetHandler.createButton(145, 240, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> this.shiftGlobalOrigin(0, 1, 0));
    private IButton buttonOriginZDecrease = BuildGuide.widgetHandler.createButton(25, 260, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> this.shiftGlobalOrigin(0, 0, -1));
    private IButton buttonOriginZIncrease = BuildGuide.widgetHandler.createButton(145, 260, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> this.shiftGlobalOrigin(0, 0, 1));
    private ITextField textFieldX = BuildGuide.widgetHandler.createTextField(45, 220, "");
    private ITextField textFieldY = BuildGuide.widgetHandler.createTextField(45, 240, "");
    private ITextField textFieldZ = BuildGuide.widgetHandler.createTextField(45, 260, "");
    private IButton buttonSetX = BuildGuide.widgetHandler.createButton(115, 220, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldX.getTextValue());
            int delta = newval - BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginX();
            BuildGuide.stateManager.getState().shiftOrigins(delta, 0, 0);
            this.textFieldX.setTextColour(0xFFFFFF);
        }
        catch (NumberFormatException e) {
            this.textFieldX.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetY = BuildGuide.widgetHandler.createButton(115, 240, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldY.getTextValue());
            int delta = newval - BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginY();
            BuildGuide.stateManager.getState().shiftOrigins(0, delta, 0);
            this.textFieldY.setTextColour(0xFFFFFF);
        }
        catch (NumberFormatException e) {
            this.textFieldY.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetZ = BuildGuide.widgetHandler.createButton(115, 260, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldZ.getTextValue());
            int delta = newval - BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginZ();
            BuildGuide.stateManager.getState().shiftOrigins(0, 0, delta);
            this.textFieldZ.setTextColour(0xFFFFFF);
        }
        catch (NumberFormatException e) {
            this.textFieldZ.setTextColour(0xFF0000);
        }
    });

    @Override
    public void init() {
        super.init();
        this.checkActive();
        this.textFieldX.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginX() : "-"));
        this.textFieldX.setTextColour(0xFFFFFF);
        this.textFieldY.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginY() : "-"));
        this.textFieldY.setTextColour(0xFFFFFF);
        this.textFieldZ.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginZ() : "-"));
        this.textFieldZ.setTextColour(0xFFFFFF);
        this.addDropdownOverlayScreen(this.dropdownOverlayScreenNewShapeSelect);
        this.addWidget(this.buttonAdd);
        this.addWidget(this.buttonVisible);
        this.addWidget(this.buttonDelete);
        this.addWidget(this.buttonGlobalOrigin);
        this.addWidget(this.buttonOriginXDecrease);
        this.addWidget(this.textFieldX);
        this.addWidget(this.buttonSetX);
        this.addWidget(this.buttonOriginXIncrease);
        this.addWidget(this.buttonOriginYDecrease);
        this.addWidget(this.textFieldY);
        this.addWidget(this.buttonSetY);
        this.addWidget(this.buttonOriginYIncrease);
        this.addWidget(this.buttonOriginZDecrease);
        this.addWidget(this.textFieldZ);
        this.addWidget(this.buttonSetZ);
        this.addWidget(this.buttonOriginZIncrease);
        this.shapeList = BuildGuide.widgetHandler.createShapelist(180, 325, 70, this.wrapper.getHeight(), () -> {
            if (BuildGuide.stateManager.getState().isShapeAvailable()) {
                this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginX());
                this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginY());
                this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginZ());
            } else {
                this.textFieldX.setTextValue("-");
                this.textFieldY.setTextValue("-");
                this.textFieldZ.setTextValue("-");
            }
            this.textFieldX.setTextColour(0xFFFFFF);
            this.textFieldY.setTextColour(0xFFFFFF);
            this.textFieldZ.setTextColour(0xFFFFFF);
            if (BuildGuide.stateManager.getState().isShapeAvailable()) {
                this.buttonVisible.setChecked(BuildGuide.stateManager.getState().getCurrentShapeSet().isVisible());
            }
            BaseScreen.shouldUpdatePersistence = true;
        });
        this.addWidget(this.shapeList);
    }

    @Override
    public void render() {
        super.render();
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleNewShape), 85, 55, 0xFFFFFF);
        this.drawShadowCentred(new AbstractScreenHandler.Translatable(ShapeRegistry.getTranslationKey(BuildGuide.stateManager.getState().getIShapeNew()), new Object[0]).toString(), 85, 75, 0xFFFFFF);
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleSelectedShape), 85, 120, 0xFFFFFF);
        this.drawShadowLeft(this.textVisible.toString(), 30, 140, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleGlobalOrigin), 85, 185, 0xFFFFFF);
        this.drawShadowLeft("X", 10, 225, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowLeft("Y", 10, 245, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowLeft("Z", 10, 265, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleShapes), 250, 55, 0xFFFFFF);
    }

    private void shiftGlobalOrigin(int dx, int dy, int dz) {
        BuildGuide.stateManager.getState().shiftOrigins(dx, dy, dz);
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            if (dx != 0) {
                this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginX());
                this.textFieldX.setTextColour(0xFFFFFF);
            }
            if (dy != 0) {
                this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginY());
                this.textFieldY.setTextColour(0xFFFFFF);
            }
            if (dz != 0) {
                this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginZ());
                this.textFieldZ.setTextColour(0xFFFFFF);
            }
        } else {
            if (dx != 0) {
                this.textFieldX.setTextValue("-");
                this.textFieldX.setTextColour(0xFFFFFF);
            }
            if (dy != 0) {
                this.textFieldY.setTextValue("-");
                this.textFieldY.setTextColour(0xFFFFFF);
            }
            if (dz != 0) {
                this.textFieldZ.setTextValue("-");
                this.textFieldZ.setTextColour(0xFFFFFF);
            }
        }
    }

    private void setGlobalOrigin() {
        ShapeSet.Origin pos = BuildGuide.shapeHandler.getPlayerPosition();
        int deltaX = pos.x - BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginX();
        int deltaY = pos.y - BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginY();
        int deltaZ = pos.z - BuildGuide.stateManager.getState().getCurrentShapeSet().getOriginZ();
        this.shiftGlobalOrigin(deltaX, deltaY, deltaZ);
    }

    private void setShapeVisibility() {
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            BuildGuide.stateManager.getState().getCurrentShapeSet().setVisible(this.buttonVisible.isCheckboxSelected());
        }
    }

    private void checkActive() {
        if (!BuildGuide.stateManager.getState().isShapeAvailable()) {
            this.buttonVisible.setActive(false);
            this.buttonDelete.setActive(false);
            this.buttonGlobalOrigin.setActive(false);
            this.buttonOriginXDecrease.setActive(false);
            this.buttonOriginXIncrease.setActive(false);
            this.buttonOriginYDecrease.setActive(false);
            this.buttonOriginYIncrease.setActive(false);
            this.buttonOriginZDecrease.setActive(false);
            this.buttonOriginZIncrease.setActive(false);
            this.buttonSetX.setActive(false);
            this.buttonSetY.setActive(false);
            this.buttonSetZ.setActive(false);
        } else {
            this.buttonVisible.setActive(true);
            this.buttonDelete.setActive(true);
            this.buttonGlobalOrigin.setActive(true);
            this.buttonOriginXDecrease.setActive(true);
            this.buttonOriginXIncrease.setActive(true);
            this.buttonOriginYDecrease.setActive(true);
            this.buttonOriginYIncrease.setActive(true);
            this.buttonOriginZDecrease.setActive(true);
            this.buttonOriginZIncrease.setActive(true);
            this.buttonSetX.setActive(true);
            this.buttonSetY.setActive(true);
            this.buttonSetZ.setActive(true);
        }
    }
}

