/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.neoforge.shape;

import brentmaas.buildguide.common.shape.IShapeBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class ShapeBuffer
implements IShapeBuffer {
    private ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(28);
    private BufferBuilder bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
    private VertexBuffer buffer;
    private int defaultR = 255;
    private int defaultG = 255;
    private int defaultB = 255;
    private int defaultA = 255;

    @Override
    public void setColour(int r, int g, int b, int a) {
        this.defaultR = r;
        this.defaultG = g;
        this.defaultB = b;
        this.defaultA = a;
    }

    @Override
    public void pushVertex(double x, double y, double z) {
        this.bufferBuilder.addVertex((float)x, (float)y, (float)z).setColor(this.defaultR, this.defaultG, this.defaultB, this.defaultA);
    }

    @Override
    public void end() {
        this.buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.buffer.bind();
        this.buffer.upload(this.bufferBuilder.build());
        VertexBuffer.unbind();
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    public void render(Matrix4f model, Matrix4f projection) {
        this.buffer.bind();
        this.buffer.drawWithShader(model, RenderSystem.getProjectionMatrix(), GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
    }
}

