/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticwindows.block.custom.EmptyWindowBlock;
import net.alminoris.aestheticwindows.block.custom.EmptyWindowVerticalBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneEmptyWindowBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneEmptyWindowVerticalBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneWindowBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneWindowVerticalBlock;
import net.alminoris.aestheticwindows.block.custom.WindowBlock;
import net.alminoris.aestheticwindows.block.custom.WindowVerticalBlock;
import net.alminoris.aestheticwindows.item.ModItemGroups;
import net.alminoris.aestheticwindows.item.ModItems;
import net.alminoris.aestheticwindows.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aestheticwindows");
    public static final Dictionary<String, RegistryObject<Block>> WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("window_" + name, () -> new WindowBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> VERTICAL_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_window_" + name, () -> new WindowVerticalBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> FOURPANE_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("fourpane_window_" + name, () -> new FourpaneWindowBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> VERTICAL_FOURPANE_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_fourpane_window_" + name, () -> new FourpaneWindowVerticalBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> EMPTY_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("empty_window_" + name, () -> new EmptyWindowBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("empty_window_" + name, () -> new EmptyWindowBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> VERTICAL_EMPTY_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("vertical_empty_window_" + name, () -> new EmptyWindowVerticalBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_empty_window_" + name, () -> new EmptyWindowVerticalBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> FOURPANE_EMPTY_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> VERTICAL_FOURPANE_EMPTY_WINDOWS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("vertical_fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowVerticalBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowVerticalBlock(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().tab(ModItemGroups.AWS_TAB)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

