/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticwindows.block.custom.EmptyWindowBlock;
import net.alminoris.aestheticwindows.block.custom.EmptyWindowVerticalBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneEmptyWindowBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneEmptyWindowVerticalBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneWindowBlock;
import net.alminoris.aestheticwindows.block.custom.FourpaneWindowVerticalBlock;
import net.alminoris.aestheticwindows.block.custom.WindowBlock;
import net.alminoris.aestheticwindows.block.custom.WindowVerticalBlock;
import net.alminoris.aestheticwindows.item.ModItems;
import net.alminoris.aestheticwindows.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"aestheticwindows");
    public static final Dictionary<String, DeferredBlock<Block>> WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("window_" + name, () -> new WindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> VERTICAL_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_window_" + name, () -> new WindowVerticalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> FOURPANE_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("fourpane_window_" + name, () -> new FourpaneWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> VERTICAL_FOURPANE_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoodsNStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_fourpane_window_" + name, () -> new FourpaneWindowVerticalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> EMPTY_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("empty_window_" + name, () -> new EmptyWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("empty_window_" + name, () -> new EmptyWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> VERTICAL_EMPTY_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("vertical_empty_window_" + name, () -> new EmptyWindowVerticalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_empty_window_" + name, () -> new EmptyWindowVerticalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> FOURPANE_EMPTY_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> VERTICAL_FOURPANE_EMPTY_WINDOWS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("vertical_fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowVerticalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("vertical_fourpane_empty_window_" + name, () -> new FourpaneEmptyWindowVerticalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
            }
        }
    };

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

