/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticwindows.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticwindows.sound.ModSounds;
import net.alminoris.aestheticwindows.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseWindowBlock
extends YAxisRotatedBlock {
    protected static final VoxelShape SHAPE = BaseWindowBlock.box((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    protected static final VoxelShape UP = BaseWindowBlock.box((double)1.0, (double)15.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5);
    protected static final VoxelShape DOWN = BaseWindowBlock.box((double)1.0, (double)0.0, (double)6.5, (double)15.0, (double)1.0, (double)9.5);
    protected static final VoxelShape LEFT = BaseWindowBlock.box((double)0.0, (double)0.0, (double)6.5, (double)1.0, (double)16.0, (double)9.5);
    protected static final VoxelShape RIGHT = BaseWindowBlock.box((double)15.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);

    public BaseWindowBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VARIANT, OPEN});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    protected VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            boxes.add(UP.bounds());
            boxes.add(DOWN.bounds());
            boxes.add(LEFT.bounds());
            boxes.add(RIGHT.bounds());
        } else {
            boxes.add(SHAPE.bounds());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getMainHandItem().isEmpty() || state.getValue(VARIANT) == Variant.CENTER) {
            return InteractionResult.PASS;
        }
        Variant currentVariant = (Variant)((Object)state.getValue(VARIANT));
        boolean currentOpen = (Boolean)state.getValue((Property)OPEN);
        if (!world.isClientSide) {
            if (!currentOpen) {
                this.playSound(world, player, (SoundEvent)ModSounds.OPEN_WINDOW.get(), 1.0f, 1.0f);
            } else {
                this.playSound(world, player, (SoundEvent)ModSounds.CLOSE_WINDOW.get(), 1.0f, 1.0f);
            }
            currentOpen = !currentOpen;
            Direction currentFacing = (Direction)state.getValue((Property)FACING);
            world.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue(VARIANT, (Comparable)((Object)currentVariant))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void playSound(Level world, Player player, SoundEvent sound, float volume, float pitch) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), sound, player.getSoundSource(), volume, pitch);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        return this.updateGardenWindowVariant(state, world, pos);
    }

    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        this.updateSurroundingGardenWindows(world, pos);
    }

    private void updateSurroundingGardenWindows(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.offset(direction.getNormal());
            BlockState neighborState = world.getBlockState(neighborPos);
            if (!(neighborState.getBlock() instanceof BaseWindowBlock)) continue;
            world.setBlock(neighborPos, this.updateGardenWindowVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateGardenWindowVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.offset(facing.getCounterClockWise(Direction.Axis.Y).getNormal());
        BlockPos rightPos = pos.offset(facing.getClockWise(Direction.Axis.Y).getNormal());
        boolean leftConnected = this.isWindow(world, leftPos, facing);
        boolean rightConnected = this.isWindow(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isWindow(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof BaseWindowBlock && state.getValue((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

