/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block.custom;

import java.util.ArrayList;
import java.util.HashSet;
import net.alminoris.aestheticwindows.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticwindows.sound.ModSounds;
import net.alminoris.aestheticwindows.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseWindowVerticalBlock
extends YAxisRotatedBlock {
    protected static final VoxelShape SHAPE = BaseWindowVerticalBlock.box((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    protected static final VoxelShape UP = BaseWindowVerticalBlock.box((double)1.0, (double)15.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5);
    protected static final VoxelShape DOWN = BaseWindowVerticalBlock.box((double)1.0, (double)0.0, (double)6.5, (double)15.0, (double)1.0, (double)9.5);
    protected static final VoxelShape LEFT = BaseWindowVerticalBlock.box((double)0.0, (double)0.0, (double)6.5, (double)1.0, (double)16.0, (double)9.5);
    protected static final VoxelShape RIGHT = BaseWindowVerticalBlock.box((double)15.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);

    public BaseWindowVerticalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VARIANT, OPEN, FLIPPED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    protected VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            switch (((Variant)((Object)state.getValue(VARIANT))).ordinal()) {
                case 0: {
                    boxes.add(UP.bounds());
                    boxes.add(DOWN.bounds());
                    break;
                }
                case 2: {
                    boxes.add(UP.bounds());
                    break;
                }
                case 3: {
                    boxes.add(DOWN.bounds());
                }
            }
            boxes.add(LEFT.bounds());
            boxes.add(RIGHT.bounds());
        } else {
            boxes.add(SHAPE.bounds());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.getMainHandItem().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            this.playSound(world, player, (SoundEvent)ModSounds.OPEN_WINDOW.get(), 1.0f, 1.0f);
        } else {
            this.playSound(world, player, (SoundEvent)ModSounds.CLOSE_WINDOW.get(), 1.0f, 1.0f);
        }
        boolean newOpen = (Boolean)state.getValue((Property)OPEN) == false;
        Direction facing = (Direction)state.getValue((Property)FACING);
        ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.add(pos);
        while (!stack.isEmpty()) {
            BlockState currentState;
            BlockPos currentPos = (BlockPos)stack.remove(stack.size() - 1);
            if (!visited.add(currentPos) || !((currentState = world.getBlockState(currentPos)).getBlock() instanceof BaseWindowVerticalBlock) || currentState.getValue((Property)FACING) != facing) continue;
            Variant currentVariant = (Variant)((Object)currentState.getValue(VARIANT));
            if (currentVariant == Variant.UP || currentVariant == Variant.DOWN || currentVariant == Variant.CENTER) {
                world.setBlock(currentPos, (BlockState)currentState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(newOpen)), 3);
                stack.add(currentPos.above());
                stack.add(currentPos.below());
                continue;
            }
            if (currentVariant != Variant.NORMAL) continue;
            world.setBlock(currentPos, (BlockState)currentState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(newOpen)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    private void playSound(Level world, Player player, SoundEvent sound, float volume, float pitch) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), sound, player.getSoundSource(), volume, pitch);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        return this.updateVerticalWindowVariant(state, world, pos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        this.updateSurroundingVerticalWindows(world, pos);
    }

    private void updateSurroundingVerticalWindows(Level world, BlockPos pos) {
        for (Direction direction : new Direction[]{Direction.UP, Direction.DOWN}) {
            BlockPos neighborPos = pos.offset(direction.getNormal());
            BlockState neighborState = world.getBlockState(neighborPos);
            if (!(neighborState.getBlock() instanceof BaseWindowVerticalBlock)) continue;
            world.setBlock(neighborPos, this.updateVerticalWindowVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateVerticalWindowVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos upPos = pos.above();
        BlockPos downPos = pos.below();
        boolean upConnected = this.isWindow(world, upPos, facing);
        boolean downConnected = this.isWindow(world, downPos, facing);
        Variant variant = Variant.NORMAL;
        if (upConnected && downConnected) {
            variant = Variant.CENTER;
        } else if (upConnected) {
            variant = Variant.DOWN;
        } else if (downConnected) {
            variant = Variant.UP;
        }
        BlockPos leftPos = pos.offset(facing.getClockWise(Direction.Axis.Y).getNormal());
        boolean flipped = this.isWindow(world, leftPos, facing);
        return (BlockState)((BlockState)state.setValue(VARIANT, (Comparable)((Object)variant))).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped));
    }

    private boolean isWindow(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() instanceof BaseWindowVerticalBlock && state.getValue((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

