/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block.custom;

import java.util.ArrayList;
import java.util.Hashtable;
import net.alminoris.aestheticwindows.block.ModBlocks;
import net.alminoris.aestheticwindows.block.custom.BaseWindowBlock;
import net.alminoris.aestheticwindows.util.helper.BlockSetsHelper;
import net.alminoris.aestheticwindows.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FourpaneEmptyWindowBlock
extends BaseWindowBlock {
    public FourpaneEmptyWindowBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(UP.bounds());
        boxes.add(DOWN.bounds());
        boxes.add(LEFT.bounds());
        boxes.add(RIGHT.bounds());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getMainHandItem();
        if (!world.isClientSide && !this.getMaterialName().isEmpty() && stack.is(Blocks.GLASS_PANE.asItem())) {
            stack.shrink(1);
            world.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)((Block)ModBlocks.FOURPANE_WINDOWS.get(this.getMaterialName()).get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)VARIANT, (Comparable)((Object)((BaseWindowBlock.Variant)((Object)state.getValue((Property)VARIANT)))))).setValue((Property)OPEN, (Comparable)((Boolean)state.getValue((Property)OPEN)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))), 3);
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    private String getMaterialName() {
        if (BlockSetsHelper.getKeyByValue((Hashtable)ModBlocks.FOURPANE_EMPTY_WINDOWS, this) != null) {
            return BlockSetsHelper.getKeyByValue((Hashtable)ModBlocks.FOURPANE_EMPTY_WINDOWS, this);
        }
        return "";
    }
}

