/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block.custom;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import net.alminoris.aestheticwindows.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticwindows.sound.ModSounds;
import net.alminoris.aestheticwindows.util.helper.BlockShape;
import net.alminoris.aestheticwindows.util.helper.VoxelShapeHelper;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class BaseWindowBlock
extends YAxisRotatedBlock {
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    protected static final class_265 UP = class_2248.method_9541((double)1.0, (double)15.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5);
    protected static final class_265 DOWN = class_2248.method_9541((double)1.0, (double)0.0, (double)6.5, (double)15.0, (double)1.0, (double)9.5);
    protected static final class_265 LEFT = class_2248.method_9541((double)0.0, (double)0.0, (double)6.5, (double)1.0, (double)16.0, (double)9.5);
    protected static final class_265 RIGHT = class_2248.method_9541((double)15.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 OPEN = class_2746.method_11825((String)"open");
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);

    public BaseWindowBlock(class_4970.class_2251 settings) {
        super(settings.method_22488(), new BlockShape[0]);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, VARIANT, OPEN, WATERLOGGED});
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    protected class_265 getRotatedShape(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        if (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue()) {
            boxes.add(UP.method_1107());
            boxes.add(DOWN.method_1107());
            boxes.add(LEFT.method_1107());
            boxes.add(RIGHT.method_1107());
        } else {
            boxes.add(SHAPE.method_1107());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!player.method_6047().method_7960() || state.method_11654(VARIANT) == Variant.CENTER) {
            return class_1269.field_5811;
        }
        Variant currentVariant = (Variant)((Object)state.method_11654(VARIANT));
        boolean currentOpen = (Boolean)state.method_11654((class_2769)OPEN);
        if (!world.field_9236) {
            if (!currentOpen) {
                this.playSound(world, player, ModSounds.OPEN_WINDOW, 1.0f, 1.0f);
            } else {
                this.playSound(world, player, ModSounds.CLOSE_WINDOW, 1.0f, 1.0f);
            }
            currentOpen = !currentOpen;
            class_2350 currentFacing = (class_2350)state.method_11654((class_2769)FACING);
            world.method_8501(pos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)currentFacing)).method_11657(VARIANT, (Comparable)((Object)currentVariant))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(currentOpen)));
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    private void playSound(class_1937 world, class_1657 player, class_3414 sound, float volume, float pitch) {
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), sound, player.method_5634(), volume, pitch);
    }

    protected static String getKeyByValue(Hashtable<String, class_2248> table, class_2248 value) {
        for (Map.Entry<String, class_2248> entry : table.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        boolean waterlogged = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return this.updateGardenWindowVariant(state, world, pos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateSurroundingGardenWindows(world, pos);
    }

    private void updateSurroundingGardenWindows(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (!(neighborState.method_26204() instanceof BaseWindowBlock)) continue;
            world.method_8501(neighborPos, this.updateGardenWindowVariant(neighborState, (class_1936)world, neighborPos));
        }
    }

    private class_2680 updateGardenWindowVariant(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        boolean leftConnected = this.isWindow(world, leftPos, facing);
        boolean rightConnected = this.isWindow(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isWindow(class_1936 world, class_2338 pos, class_2350 facing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof BaseWindowBlock && state.method_11654((class_2769)FACING) == facing;
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

