/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.InfoTooltip;
import com.brokenkeyboard.usefulspyglass.config.ClientConfig;
import com.brokenkeyboard.usefulspyglass.platform.Services;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableInt;

public class DrawOverlay {
    private static final ConcurrentMap<String, String> MODLIST = Services.PLATFORM.getModList();
    private static final Minecraft CLIENT = Minecraft.getInstance();
    public static HitResult hitResult = null;

    public static void drawGUI(GuiGraphics graphics) {
        int n;
        int rectangleHeight;
        int screenWidth = CLIENT.getWindow().getGuiScaledWidth();
        int screenHeight = CLIENT.getWindow().getGuiScaledHeight();
        int xPos = (int)((double)screenWidth * (Double)ClientConfig.HUD_X.get());
        int yPos = (int)((double)screenHeight * (Double)ClientConfig.HUD_Y.get());
        ArrayList<InfoTooltip> tooltips = new ArrayList<InfoTooltip>();
        ArrayList<InfoTooltip> eventTooltips = new ArrayList<InfoTooltip>();
        TooltipDimensions dimension = DrawOverlay.createTooltips(hitResult, tooltips, eventTooltips);
        boolean isBlock = hitResult instanceof BlockHitResult && DrawOverlay.CLIENT.player != null;
        boolean oneLine = tooltips.size() == 1;
        boolean hasExtraTooltips = !eventTooltips.isEmpty();
        int rectangleLeft = xPos - dimension.WIDTH / 2;
        int rectangleX = DrawOverlay.adjustAxis(rectangleLeft, dimension.WIDTH, screenWidth);
        int rectangleY = DrawOverlay.adjustAxis(yPos, dimension.BASE_HEIGHT + dimension.EXTRA_HEIGHT, screenHeight);
        int margin = hasExtraTooltips ? (hitResult instanceof BlockHitResult && oneLine ? 8 : 2) : 0;
        int n2 = rectangleHeight = isBlock && oneLine && !hasExtraTooltips ? 18 : dimension.BASE_HEIGHT + dimension.EXTRA_HEIGHT + margin;
        if (isBlock && oneLine) {
            Objects.requireNonNull(DrawOverlay.CLIENT.font);
            Objects.requireNonNull(DrawOverlay.CLIENT.font);
            n = rectangleY + 9 - 9 / 2;
        } else {
            n = rectangleY;
        }
        int yOffset = n;
        graphics.pose().pushPose();
        graphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)rectangleX, (int)rectangleY, (int)dimension.WIDTH, (int)rectangleHeight, (int)400));
        if (isBlock) {
            BlockState state = DrawOverlay.CLIENT.player.level().getBlockState(((BlockHitResult)hitResult).getBlockPos());
            ItemStack stack = state.getBlock().getCloneItemStack((LevelReader)DrawOverlay.CLIENT.player.level(), ((BlockHitResult)hitResult).getBlockPos(), state);
            int stackYPos = oneLine ? rectangleY : rectangleY + dimension.BASE_HEIGHT / 2 - 8;
            DrawOverlay.renderStack(graphics, stack, xPos - dimension.X_OFFSET, stackYPos);
        }
        for (InfoTooltip info : tooltips) {
            info.render(graphics, xPos - dimension.X_OFFSET, yOffset);
            yOffset += info.getHeight();
        }
        if (hasExtraTooltips) {
            yOffset += 4;
        }
        for (InfoTooltip info : eventTooltips) {
            info.render(graphics, xPos - dimension.X_OFFSET_EXTRA, yOffset);
            yOffset += info.getHeight();
        }
        graphics.pose().popPose();
    }

    private static TooltipDimensions createTooltips(HitResult result, ArrayList<InfoTooltip> tooltips, ArrayList<InfoTooltip> eventTooltips) {
        Object entityHit;
        Entity entity;
        MutableInt baseWidth = new MutableInt(0);
        MutableInt baseHeight = new MutableInt(0);
        MutableInt extraWidth = new MutableInt(0);
        MutableInt extraHeight = new MutableInt(0);
        ArrayList<ClientTooltipComponent> toAdd = new ArrayList<ClientTooltipComponent>();
        if (result instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            String entityName = entity2.getDisplayName().getString();
            Consumer<ClientTooltipComponent> textConsumer = tooltip -> {
                InfoTooltip.Text text = new InfoTooltip.Text((ClientTooltipComponent)tooltip);
                tooltips.add(text);
                baseHeight.add(text.getHeight());
                baseWidth.setValue(Math.max(baseWidth.getValue(), text.getWidth()));
            };
            DrawOverlay.createTextLines(textConsumer, entityName, DrawOverlay.getEntityColor(entity2));
            HashMap<InfoTooltip.Icon, ClientTooltipComponent> map = new HashMap<InfoTooltip.Icon, ClientTooltipComponent>();
            map.put(InfoTooltip.Icon.HEALTH, ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)String.valueOf((int)entity2.getHealth())).getVisualOrderText()));
            if (entity2.getArmorValue() > 0) {
                map.put(InfoTooltip.Icon.ARMOR, ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)String.valueOf(entity2.getArmorValue())).getVisualOrderText()));
            }
            InfoTooltip.MobStatus status = new InfoTooltip.MobStatus(map);
            tooltips.add(status);
            baseHeight.add(status.getHeight());
            baseWidth.setValue(Math.max(baseWidth.getValue(), status.getWidth()));
            if (((Boolean)ClientConfig.DISPLAY_NAMESPACE.get()).booleanValue()) {
                namespace = (String)MODLIST.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity2.getType()).getNamespace());
                DrawOverlay.createTextLines(textConsumer, namespace, ChatFormatting.BLUE);
            }
            Services.PLATFORM.livingTooltipCallback(entity2, toAdd);
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            if (DrawOverlay.CLIENT.player != null) {
                BlockPos pos = blockHit.getBlockPos();
                BlockState state = DrawOverlay.CLIENT.player.level().getBlockState(pos);
                String blockName = state.getBlock().getName().getString();
                Consumer<ClientTooltipComponent> textConsumer = tooltip -> {
                    InfoTooltip.BlockName text = new InfoTooltip.BlockName((ClientTooltipComponent)tooltip);
                    tooltips.add(text);
                    baseHeight.add(((InfoTooltip.Text)text).getHeight());
                    baseWidth.setValue(Math.max(baseWidth.getValue(), ((InfoTooltip.Text)text).getWidth()));
                };
                DrawOverlay.createTextLines(textConsumer, blockName, ChatFormatting.WHITE);
                if (((Boolean)ClientConfig.DISPLAY_NAMESPACE.get()).booleanValue()) {
                    namespace = (String)MODLIST.get(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace());
                    DrawOverlay.createTextLines(textConsumer, namespace, ChatFormatting.BLUE);
                }
                Services.PLATFORM.blockTooltipCallback(state, pos, toAdd);
            }
        }
        for (ClientTooltipComponent component : toAdd) {
            InfoTooltip.Text text = new InfoTooltip.Text(component);
            eventTooltips.add(text);
            extraHeight.add(text.getHeight());
            extraWidth.setValue(Math.max(extraWidth.getValue(), text.getWidth()));
        }
        int xOffset = baseWidth.getValue() / 2;
        int xOffsetExtra = baseWidth.getValue() > extraWidth.getValue() ? xOffset : extraWidth.getValue() / 2;
        int width = Math.max(baseWidth.getValue(), extraWidth.getValue());
        return new TooltipDimensions(xOffset, baseHeight.getValue(), xOffsetExtra, extraHeight.getValue(), width);
    }

    private static void createTextLines(Consumer<ClientTooltipComponent> consumer, String text, ChatFormatting color) {
        String[] strings = text.split(" +");
        if (strings.length > 1) {
            int maxLength = CLIENT.getWindow().getGuiScaledWidth() / 5;
            StringBuilder str = new StringBuilder();
            for (String addStr : strings) {
                if (ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)(String.valueOf(str) + " " + addStr)).getVisualOrderText()).getWidth(DrawOverlay.CLIENT.font) > maxLength && !str.isEmpty()) {
                    consumer.accept(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)str.toString()).withStyle(color).getVisualOrderText()));
                    str = new StringBuilder();
                }
                if (!str.isEmpty()) {
                    str.append(" ");
                }
                str.append(addStr);
            }
            consumer.accept(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)str.toString()).withStyle(color).getVisualOrderText()));
        } else {
            consumer.accept(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)text).withStyle(color).getVisualOrderText()));
        }
    }

    private static int adjustAxis(int pos, int offset, int max) {
        if (pos - 4 < 0) {
            return 4;
        }
        if (pos + offset + 4 > max) {
            return max - offset - 4;
        }
        return pos;
    }

    private static ChatFormatting getEntityColor(LivingEntity entity) {
        if (entity instanceof Player) {
            return ChatFormatting.BLUE;
        }
        if (entity instanceof NeutralMob) {
            return ChatFormatting.YELLOW;
        }
        if (entity.getType().getCategory().isFriendly()) {
            return ChatFormatting.GREEN;
        }
        if (entity.getType().getCategory() == MobCategory.MONSTER) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.WHITE;
    }

    private static void renderStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        graphics.pose().pushPose();
        Lighting.setupFor3DItems();
        RenderSystem.enableDepthTest();
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(DrawOverlay.CLIENT.font, stack, x, y, null);
        Lighting.setupForFlatItems();
        RenderSystem.disableDepthTest();
        graphics.pose().popPose();
    }

    private record TooltipDimensions(int X_OFFSET, int BASE_HEIGHT, int X_OFFSET_EXTRA, int EXTRA_HEIGHT, int WIDTH) {
    }
}

