/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class InfoTooltip {
    public static final ResourceLocation CONTAINER = ResourceLocation.withDefaultNamespace((String)"hud/heart/container");

    abstract int getWidth();

    abstract int getHeight();

    abstract void render(GuiGraphics var1, int var2, int var3);

    private static void renderText(GuiGraphics graphics, ClientTooltipComponent component, int x, int y) {
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        graphics.pose().pushPose();
        component.renderText(Minecraft.getInstance().font, x, y, graphics.pose().last().pose(), graphics.bufferSource());
        graphics.pose().popPose();
    }

    private static void renderIcon(GuiGraphics graphics, ResourceLocation location, int x, int y) {
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        graphics.pose().pushPose();
        graphics.blitSprite(location, x, y, 9, 9);
        graphics.pose().popPose();
    }

    static enum Icon {
        HEALTH(ResourceLocation.withDefaultNamespace((String)"hud/heart/full"), 9, 9),
        ARMOR(ResourceLocation.withDefaultNamespace((String)"hud/armor_full"), 9, 9);

        public final ResourceLocation LOCATION;
        public final int ICON_WIDTH;
        public final int ICON_HEIGHT;

        private Icon(ResourceLocation location, int iconWidth, int iconHeight) {
            this.LOCATION = location;
            this.ICON_WIDTH = iconWidth;
            this.ICON_HEIGHT = iconHeight;
        }
    }

    static class MobStatus
    extends InfoTooltip {
        public final Map<Icon, ClientTooltipComponent> MOB_INFO;

        public MobStatus(Map<Icon, ClientTooltipComponent> map) {
            this.MOB_INFO = map;
        }

        @Override
        public int getWidth() {
            int width = 0;
            for (Map.Entry<Icon, ClientTooltipComponent> entry : this.MOB_INFO.entrySet()) {
                width += entry.getValue().getWidth(Minecraft.getInstance().font) + entry.getKey().ICON_WIDTH + 4;
            }
            return width;
        }

        @Override
        public int getHeight() {
            Objects.requireNonNull(Minecraft.getInstance().font);
            return 9 + 1;
        }

        @Override
        void render(GuiGraphics graphics, int x, int y) {
            int xOffset = x;
            for (Map.Entry<Icon, ClientTooltipComponent> entry : this.MOB_INFO.entrySet()) {
                if (entry.getKey() == Icon.HEALTH) {
                    InfoTooltip.renderIcon(graphics, CONTAINER, xOffset, y);
                }
                InfoTooltip.renderIcon(graphics, entry.getKey().LOCATION, xOffset, y);
                InfoTooltip.renderText(graphics, entry.getValue(), xOffset += entry.getKey().ICON_WIDTH + 2, y);
                xOffset += entry.getValue().getWidth(Minecraft.getInstance().font) + 2;
            }
        }
    }

    static class BlockName
    extends Text {
        public BlockName(ClientTooltipComponent tooltip) {
            super(tooltip);
        }

        @Override
        int getWidth() {
            return 18 + this.TOOLTIP.getWidth(Minecraft.getInstance().font);
        }

        @Override
        public int getHeight() {
            return this.TOOLTIP.getHeight();
        }

        @Override
        void render(GuiGraphics graphics, int x, int y) {
            InfoTooltip.renderText(graphics, this.TOOLTIP, x + 18, y);
        }
    }

    static class Text
    extends InfoTooltip {
        public final ClientTooltipComponent TOOLTIP;

        public Text(ClientTooltipComponent tooltip) {
            this.TOOLTIP = tooltip;
        }

        @Override
        int getWidth() {
            return this.TOOLTIP.getWidth(Minecraft.getInstance().font);
        }

        @Override
        int getHeight() {
            return this.TOOLTIP.getHeight();
        }

        @Override
        void render(GuiGraphics graphics, int x, int y) {
            InfoTooltip.renderText(graphics, this.TOOLTIP, x, y);
        }
    }
}

