/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass.platform;

import com.brokenkeyboard.usefulspyglass.Curios;
import com.brokenkeyboard.usefulspyglass.EntityFinder;
import com.brokenkeyboard.usefulspyglass.ModRegistry;
import com.brokenkeyboard.usefulspyglass.UsefulSpyglass;
import com.brokenkeyboard.usefulspyglass.api.event.BlockTooltipEvent;
import com.brokenkeyboard.usefulspyglass.api.event.LivingTooltipEvent;
import com.brokenkeyboard.usefulspyglass.network.ServerHandler;
import com.brokenkeyboard.usefulspyglass.network.SpyglassEnchPayload;
import com.brokenkeyboard.usefulspyglass.platform.IPlatformHelper;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.language.IModInfo;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean hasSpyglassEnchant(Player player, ResourceKey<Enchantment> enchant) {
        ItemStack stack = player.getUseItem();
        Holder.Reference targetEnchantment = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchant);
        Predicate<ItemStack> predicate = arg_0 -> NeoForgePlatformHelper.lambda$hasSpyglassEnchant$0((Holder)targetEnchantment, arg_0);
        return EnchantmentHelper.getTagEnchantmentLevel((Holder)player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchant), (ItemStack)stack) > 0 || ModList.get().isLoaded("curios") && Curios.checkCurios(player, predicate) && !ServerHandler.usingPrecision(player) && stack.getItem() != Items.SPYGLASS;
    }

    @Override
    public boolean hasPrecision(Player player) {
        Holder.Reference targetEnchantment = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ModRegistry.PRECISION);
        Predicate<ItemStack> predicate = arg_0 -> NeoForgePlatformHelper.lambda$hasPrecision$1((Holder)targetEnchantment, arg_0);
        return EnchantmentHelper.getTagEnchantmentLevel((Holder)player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ModRegistry.PRECISION), (ItemStack)player.getItemInHand(InteractionHand.OFF_HAND)) > 0 || ModList.get().isLoaded("curios") && Curios.checkCurios(player, predicate);
    }

    @Override
    public boolean testPrecisionCompat(Player player) {
        for (Predicate<?> predicate : UsefulSpyglass.PRECISION_COMPATIBLE) {
            try {
                if (!predicate.test(player)) continue;
                return true;
            }
            catch (ClassCastException exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public HitResult getHitResult(Camera camera, float partialTick, Player player) {
        if (ModList.get().isLoaded("shouldersurfing") && ShoulderSurfing.getInstance().isShoulderSurfing()) {
            PickContext pickContext = new PickContext.Builder(camera).withEntity((Entity)player).withFluidContext(ClipContext.Fluid.NONE).build();
            return ShoulderSurfing.getInstance().getObjectPicker().pick(pickContext, 100.0, partialTick, player);
        }
        return EntityFinder.getAimedObject(player.level(), camera.getEntity(), camera.getPosition(), camera.getEntity().getViewVector(partialTick));
    }

    @Override
    public void useSpyglassEnch() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SpyglassEnchPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setPrecisionBonus(Projectile projectile) {
        projectile.setData(UsefulSpyglass.PRECISION_BONUS, (Object)1.2);
    }

    @Override
    public boolean hasPrecisionBonus(Projectile projectile) {
        return projectile.hasData(UsefulSpyglass.PRECISION_BONUS);
    }

    @Override
    public void livingTooltipCallback(LivingEntity entity, List<ClientTooltipComponent> eventTooltips) {
        LivingTooltipEvent event = new LivingTooltipEvent(entity, eventTooltips);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public void blockTooltipCallback(BlockState state, BlockPos pos, List<ClientTooltipComponent> tooltipInfoList) {
        BlockTooltipEvent event = new BlockTooltipEvent(state, pos, tooltipInfoList);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public ConcurrentMap<String, String> getModList() {
        ConcurrentMap map = Maps.newConcurrentMap();
        List list = ModList.get().getMods();
        for (IModInfo mod : list) {
            String modid = mod.getModId();
            String name = mod.getDisplayName() != null ? mod.getDisplayName() : modid;
            map.put(modid, name);
        }
        return map;
    }

    private static /* synthetic */ boolean lambda$hasPrecision$1(Holder targetEnchantment, ItemStack stack1) {
        return stack1.getItem() == Items.SPYGLASS && EnchantmentHelper.getTagEnchantmentLevel((Holder)targetEnchantment, (ItemStack)stack1) > 0;
    }

    private static /* synthetic */ boolean lambda$hasSpyglassEnchant$0(Holder targetEnchantment, ItemStack stack1) {
        return stack1.getItem() == Items.SPYGLASS && EnchantmentHelper.getTagEnchantmentLevel((Holder)targetEnchantment, (ItemStack)stack1) > 0;
    }
}

