/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class EntityFinder {
    public static HitResult getAimedObject(Level level, Entity entity, Vec3 start, Vec3 viewVector) {
        if (level == null || entity == null) {
            return null;
        }
        Vec3 end = start.add(viewVector.scale(100.0));
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), (Predicate)EntitySelector.LIVING_ENTITY_STILL_ALIVE, (double)0.0);
        BlockHitResult blockHit = level.clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.of((Entity)entity)));
        if (entityHit != null && !entityHit.getEntity().isInvisible()) {
            double blockDistance = blockHit.getLocation().distanceToSqr(start);
            double entityDistance = entityHit.getLocation().distanceToSqr(start);
            return entityDistance < blockDistance ? entityHit : blockHit;
        }
        if (blockHit.getType() == HitResult.Type.BLOCK) {
            return blockHit;
        }
        return null;
    }
}

