/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.MarkedEntitiesAccess;
import com.brokenkeyboard.usefulspyglass.config.CommonConfig;
import com.brokenkeyboard.usefulspyglass.mixin.EyeOfEnderAccessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class SpotterEye
extends EyeOfEnder {
    private ServerPlayer owner;
    private Vec3 position;
    public boolean inPosition = false;

    public SpotterEye(EntityType<? extends SpotterEye> type, Level level) {
        super(type, level);
    }

    public SpotterEye(Level level, double x, double y, double z, ServerPlayer owner) {
        super(level, x, y, z);
        this.owner = owner;
    }

    public void signalTo(BlockPos pos) {
        ((EyeOfEnderAccessor)((Object)this)).setTx(pos.getX());
        ((EyeOfEnderAccessor)((Object)this)).setTy(pos.getY());
        ((EyeOfEnderAccessor)((Object)this)).setTz(pos.getZ());
        ((EyeOfEnderAccessor)((Object)this)).setLife(80 - (Integer)CommonConfig.SPOTTER_DURATION.get());
        ((EyeOfEnderAccessor)((Object)this)).setSurviveAfterDeath(false);
        this.position = pos.getCenter();
    }

    public void tick() {
        super.tick();
        if (this.inPosition && this.level() instanceof ServerLevel && this.owner != null && ((EyeOfEnderAccessor)((Object)this)).getLife() % 80 == 0) {
            int range = (Integer)CommonConfig.SPOTTER_RANGE.get();
            AABB aabb = new AABB(this.getX() - (double)range, this.getY() - (double)range, this.getZ() - (double)range, this.getX() + (double)range, this.getY() + (double)range, this.getZ() + (double)range);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
            entities.removeIf(entity -> !SpotterEye.hasLOS(this.level(), entity.getEyePosition(), this.position()));
            for (LivingEntity entity2 : entities) {
                ((MarkedEntitiesAccess)this.owner).us$getMarkedEntities().addEntity((Entity)entity2, 100);
            }
        } else if (!this.inPosition && this.position().distanceTo(this.position) < 1.0) {
            this.inPosition = true;
        }
    }

    private static boolean hasLOS(Level level, Vec3 startPos, Vec3 targetPos) {
        BlockHitResult result = level.clip(new ClipContext(startPos, targetPos, ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, CollisionContext.empty()));
        return result.getBlockPos().equals((Object)BlockPos.containing((Position)targetPos)) || result.getType() == HitResult.Type.MISS;
    }
}

