/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.DrawOverlay;
import com.brokenkeyboard.usefulspyglass.ModRegistry;
import com.brokenkeyboard.usefulspyglass.config.ClientConfig;
import com.brokenkeyboard.usefulspyglass.config.CommonConfig;
import com.brokenkeyboard.usefulspyglass.network.ClientHandler;
import com.brokenkeyboard.usefulspyglass.network.ServerHandler;
import com.brokenkeyboard.usefulspyglass.network.SpyglassEnchPayload;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="usefulspyglass")
public class UsefulSpyglass {
    public static final ArrayList<Predicate<?>> PRECISION_COMPATIBLE = new ArrayList();
    public static final String IMC_ID = "precision";
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"usefulspyglass");
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENTS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"usefulspyglass");
    public static final Supplier<AttachmentType<Double>> PRECISION_BONUS = ATTACHMENTS.register("precision_bonus", () -> AttachmentType.builder(() -> 1.0).serialize((Codec)Codec.DOUBLE).build());
    public static final Supplier<EntityType<?>> WATCHER_EYE = ENTITIES.register("watcher_eye", () -> ModRegistry.SPOTTER_EYE);

    public UsefulSpyglass(ModContainer container, IEventBus bus) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ENTITIES.register(bus);
        ATTACHMENTS.register(bus);
        bus.addListener(this::imcProcess);
    }

    private void imcProcess(InterModProcessEvent event) {
        event.getIMCStream().forEach(imcMessage -> {
            Object patt0$temp;
            if (imcMessage.method().equals(IMC_ID) && (patt0$temp = imcMessage.messageSupplier().get()) instanceof Predicate) {
                Predicate predicate = (Predicate)patt0$temp;
                PRECISION_COMPATIBLE.add(predicate);
            }
        });
    }

    @EventBusSubscriber(modid="usefulspyglass", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void registerGUI(RegisterGuiLayersEvent event) {
            event.registerAbove(VanillaGuiLayers.DEBUG_OVERLAY, ResourceLocation.fromNamespaceAndPath((String)"usefulspyglass", (String)"hud_base"), (gui, deltaTracker) -> {
                if ((!ModList.get().isLoaded("jade") || !((Boolean)ClientConfig.JADE_INTEGRATION.get()).booleanValue()) && (DrawOverlay.hitResult instanceof EntityHitResult && ((Boolean)ClientConfig.DISPLAY_ENTITIES.get()).booleanValue() || DrawOverlay.hitResult instanceof BlockHitResult && ((Boolean)ClientConfig.DISPLAY_BLOCKS.get()).booleanValue())) {
                    DrawOverlay.drawGUI(gui);
                }
            });
        }

        @SubscribeEvent
        public static void registerRenders(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(ModRegistry.SPOTTER_EYE, context -> new ThrownItemRenderer(context, 1.0f, true));
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            ClientHandler.handleClientTick(Minecraft.getInstance());
        }
    }

    @EventBusSubscriber(modid="usefulspyglass")
    public static class Events {
        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToServer(SpyglassEnchPayload.TYPE, SpyglassEnchPayload.STREAM_CODEC, (data, context) -> context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    ServerHandler.handleEnchantments(serverPlayer);
                }
            }));
        }

        @SubscribeEvent
        public static void damageEvent(LivingIncomingDamageEvent event) {
            Projectile projectile;
            Entity entity;
            if (event.getSource().is(DamageTypeTags.IS_PROJECTILE) && (entity = event.getSource().getDirectEntity()) instanceof Projectile && (projectile = (Projectile)entity).hasData(PRECISION_BONUS)) {
                event.setAmount((float)((double)event.getAmount() * (Double)projectile.getData(PRECISION_BONUS)));
            }
        }
    }
}

