/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass.network;

import com.brokenkeyboard.usefulspyglass.EntityFinder;
import com.brokenkeyboard.usefulspyglass.MarkedEntitiesAccess;
import com.brokenkeyboard.usefulspyglass.ModRegistry;
import com.brokenkeyboard.usefulspyglass.SpotterEye;
import com.brokenkeyboard.usefulspyglass.config.CommonConfig;
import com.brokenkeyboard.usefulspyglass.platform.Services;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ServerHandler {
    private static final Predicate<Player> USING_PRECISION = player -> !player.getCooldowns().isOnCooldown(Items.SPYGLASS) && Services.PLATFORM.hasPrecision((Player)player) && player.isCrouching();
    private static final Predicate<LivingEntity> BOW = entity -> entity.getUseItem().getItem() instanceof BowItem && BowItem.getPowerForTime((int)entity.getTicksUsingItem()) >= 1.0f;
    private static final Predicate<LivingEntity> CROSSBOW = entity -> {
        ItemStack stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        return stack.getItem() instanceof CrossbowItem && CrossbowItem.isCharged((ItemStack)stack);
    };

    public static void handleEnchantments(ServerPlayer player) {
        if (player.getCooldowns().isOnCooldown(Items.SPYGLASS)) {
            return;
        }
        HitResult result = EntityFinder.getAimedObject(player.level(), (Entity)player, player.getEyePosition(1.0f), player.getViewVector(1.0f).normalize());
        if (Services.PLATFORM.hasSpyglassEnchant((Player)player, ModRegistry.MARKING) && result instanceof EntityHitResult) {
            EntityHitResult entity = (EntityHitResult)result;
            ((MarkedEntitiesAccess)player).us$getMarkedEntities().addEntity(entity.getEntity(), (Integer)CommonConfig.MARKING_DURATION.get());
            player.getCooldowns().addCooldown(Items.SPYGLASS, (int)((double)((Integer)CommonConfig.MARKING_DURATION.get()).intValue() * 0.8));
        } else if (Services.PLATFORM.hasSpyglassEnchant((Player)player, ModRegistry.SPOTTER)) {
            SpotterEye eye = new SpotterEye(player.level(), player.getX(), player.getY(0.5), player.getZ(), player);
            eye.signalTo(new BlockPos((int)result.getLocation().x(), (int)result.getLocation().y() + 3, (int)result.getLocation().z()));
            player.level().gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, eye.position(), GameEvent.Context.of((Entity)player));
            player.level().addFreshEntity((Entity)eye);
            player.getCooldowns().addCooldown(Items.SPYGLASS, (int)((double)((Integer)CommonConfig.SPOTTER_DURATION.get()).intValue() * 1.4));
        }
    }

    public static boolean usingPrecision(Player player) {
        return USING_PRECISION.test(player) && (BOW.test((LivingEntity)player) || CROSSBOW.test((LivingEntity)player) || Services.PLATFORM.testPrecisionCompat(player));
    }

    public static float handlePrecision(Entity entity, Projectile projectile, float deviation) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).getCooldowns().isOnCooldown(Items.SPYGLASS) && player.isCrouching() && Services.PLATFORM.hasPrecision(player)) {
            projectile.setNoGravity(true);
            Services.PLATFORM.setPrecisionBonus(projectile);
            player.getCooldowns().addCooldown(Items.SPYGLASS, ((Integer)CommonConfig.PRECISION_COOLDOWN.get()).intValue());
            return 0.0f;
        }
        return deviation;
    }
}

