/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.InfoTooltip;
import com.brokenkeyboard.usefulspyglass.config.ClientConfig;
import com.brokenkeyboard.usefulspyglass.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5354;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7923;
import net.minecraft.class_8002;
import org.apache.commons.lang3.mutable.MutableInt;

public class DrawOverlay {
    private static final ConcurrentMap<String, String> MODLIST = Services.PLATFORM.getModList();
    private static final class_310 CLIENT = class_310.method_1551();
    public static class_239 hitResult = null;

    public static void drawGUI(class_332 graphics) {
        int n;
        int rectangleHeight;
        int screenWidth = CLIENT.method_22683().method_4486();
        int screenHeight = CLIENT.method_22683().method_4502();
        int xPos = (int)((double)screenWidth * (Double)ClientConfig.HUD_X.get());
        int yPos = (int)((double)screenHeight * (Double)ClientConfig.HUD_Y.get());
        ArrayList<InfoTooltip> tooltips = new ArrayList<InfoTooltip>();
        ArrayList<InfoTooltip> eventTooltips = new ArrayList<InfoTooltip>();
        TooltipDimensions dimension = DrawOverlay.createTooltips(hitResult, tooltips, eventTooltips);
        boolean isBlock = hitResult instanceof class_3965 && DrawOverlay.CLIENT.field_1724 != null;
        boolean oneLine = tooltips.size() == 1;
        boolean hasExtraTooltips = !eventTooltips.isEmpty();
        int rectangleLeft = xPos - dimension.WIDTH / 2;
        int rectangleX = DrawOverlay.adjustAxis(rectangleLeft, dimension.WIDTH, screenWidth);
        int rectangleY = DrawOverlay.adjustAxis(yPos, dimension.BASE_HEIGHT + dimension.EXTRA_HEIGHT, screenHeight);
        int margin = hasExtraTooltips ? (hitResult instanceof class_3965 && oneLine ? 8 : 2) : 0;
        int n2 = rectangleHeight = isBlock && oneLine && !hasExtraTooltips ? 18 : dimension.BASE_HEIGHT + dimension.EXTRA_HEIGHT + margin;
        if (isBlock && oneLine) {
            Objects.requireNonNull(DrawOverlay.CLIENT.field_1772);
            Objects.requireNonNull(DrawOverlay.CLIENT.field_1772);
            n = rectangleY + 9 - 9 / 2;
        } else {
            n = rectangleY;
        }
        int yOffset = n;
        graphics.method_51448().method_22903();
        graphics.method_51741(() -> class_8002.method_47946((class_332)graphics, (int)rectangleX, (int)rectangleY, (int)dimension.WIDTH, (int)rectangleHeight, (int)400));
        if (isBlock) {
            class_2680 state = DrawOverlay.CLIENT.field_1724.method_37908().method_8320(((class_3965)hitResult).method_17777());
            class_1799 stack = state.method_26204().method_9574((class_1922)DrawOverlay.CLIENT.field_1724.method_37908(), ((class_3965)hitResult).method_17777(), state);
            int stackYPos = oneLine ? rectangleY : rectangleY + dimension.BASE_HEIGHT / 2 - 8;
            DrawOverlay.renderStack(graphics, stack, xPos - dimension.X_OFFSET, stackYPos);
        }
        for (InfoTooltip info : tooltips) {
            info.render(graphics, xPos - dimension.X_OFFSET, yOffset);
            yOffset += info.getHeight();
        }
        if (hasExtraTooltips) {
            yOffset += 4;
        }
        for (InfoTooltip info : eventTooltips) {
            info.render(graphics, xPos - dimension.X_OFFSET_EXTRA, yOffset);
            yOffset += info.getHeight();
        }
        graphics.method_51448().method_22909();
    }

    private static TooltipDimensions createTooltips(class_239 result, ArrayList<InfoTooltip> tooltips, ArrayList<InfoTooltip> eventTooltips) {
        Object entityHit;
        class_1297 class_12972;
        MutableInt baseWidth = new MutableInt(0);
        MutableInt baseHeight = new MutableInt(0);
        MutableInt extraWidth = new MutableInt(0);
        MutableInt extraHeight = new MutableInt(0);
        ArrayList<class_5684> toAdd = new ArrayList<class_5684>();
        if (result instanceof class_3966 && (class_12972 = (entityHit = (class_3966)result).method_17782()) instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            String entityName = entity.method_5476().getString();
            Consumer<class_5684> textConsumer = tooltip -> {
                InfoTooltip.Text text = new InfoTooltip.Text((class_5684)tooltip);
                tooltips.add(text);
                baseHeight.add(text.getHeight());
                baseWidth.setValue(Math.max(baseWidth.getValue(), text.getWidth()));
            };
            DrawOverlay.createTextLines(textConsumer, entityName, DrawOverlay.getEntityColor(entity));
            HashMap<InfoTooltip.Icon, class_5684> map = new HashMap<InfoTooltip.Icon, class_5684>();
            map.put(InfoTooltip.Icon.HEALTH, class_5684.method_32662((class_5481)class_2561.method_43470((String)String.valueOf((int)entity.method_6032())).method_30937()));
            if (entity.method_6096() > 0) {
                map.put(InfoTooltip.Icon.ARMOR, class_5684.method_32662((class_5481)class_2561.method_43470((String)String.valueOf(entity.method_6096())).method_30937()));
            }
            InfoTooltip.MobStatus status = new InfoTooltip.MobStatus(map);
            tooltips.add(status);
            baseHeight.add(status.getHeight());
            baseWidth.setValue(Math.max(baseWidth.getValue(), status.getWidth()));
            if (((Boolean)ClientConfig.DISPLAY_NAMESPACE.get()).booleanValue()) {
                namespace = (String)MODLIST.get(class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836());
                DrawOverlay.createTextLines(textConsumer, namespace, class_124.field_1078);
            }
            Services.PLATFORM.livingTooltipCallback(entity, toAdd);
        } else if (result instanceof class_3965) {
            class_3965 blockHit = (class_3965)result;
            if (DrawOverlay.CLIENT.field_1724 != null) {
                class_2338 pos = blockHit.method_17777();
                class_2680 state = DrawOverlay.CLIENT.field_1724.method_37908().method_8320(pos);
                String blockName = state.method_26204().method_9518().getString();
                Consumer<class_5684> textConsumer = tooltip -> {
                    InfoTooltip.BlockName text = new InfoTooltip.BlockName((class_5684)tooltip);
                    tooltips.add(text);
                    baseHeight.add(((InfoTooltip.Text)text).getHeight());
                    baseWidth.setValue(Math.max(baseWidth.getValue(), ((InfoTooltip.Text)text).getWidth()));
                };
                DrawOverlay.createTextLines(textConsumer, blockName, class_124.field_1068);
                if (((Boolean)ClientConfig.DISPLAY_NAMESPACE.get()).booleanValue()) {
                    namespace = (String)MODLIST.get(class_7923.field_41175.method_10221((Object)state.method_26204()).method_12836());
                    DrawOverlay.createTextLines(textConsumer, namespace, class_124.field_1078);
                }
                Services.PLATFORM.blockTooltipCallback(state, pos, toAdd);
            }
        }
        for (class_5684 component : toAdd) {
            InfoTooltip.Text text = new InfoTooltip.Text(component);
            eventTooltips.add(text);
            extraHeight.add(text.getHeight());
            extraWidth.setValue(Math.max(extraWidth.getValue(), text.getWidth()));
        }
        int xOffset = baseWidth.getValue() / 2;
        int xOffsetExtra = baseWidth.getValue() > extraWidth.getValue() ? xOffset : extraWidth.getValue() / 2;
        int width = Math.max(baseWidth.getValue(), extraWidth.getValue());
        return new TooltipDimensions(xOffset, baseHeight.getValue(), xOffsetExtra, extraHeight.getValue(), width);
    }

    private static void createTextLines(Consumer<class_5684> consumer, String text, class_124 color) {
        String[] strings = text.split(" +");
        if (strings.length > 1) {
            int maxLength = CLIENT.method_22683().method_4486() / 5;
            StringBuilder str = new StringBuilder();
            for (String addStr : strings) {
                if (class_5684.method_32662((class_5481)class_2561.method_43470((String)(String.valueOf(str) + " " + addStr)).method_30937()).method_32664(DrawOverlay.CLIENT.field_1772) > maxLength && !str.isEmpty()) {
                    consumer.accept(class_5684.method_32662((class_5481)class_2561.method_43470((String)str.toString()).method_27692(color).method_30937()));
                    str = new StringBuilder();
                }
                if (!str.isEmpty()) {
                    str.append(" ");
                }
                str.append(addStr);
            }
            consumer.accept(class_5684.method_32662((class_5481)class_2561.method_43470((String)str.toString()).method_27692(color).method_30937()));
        } else {
            consumer.accept(class_5684.method_32662((class_5481)class_2561.method_43470((String)text).method_27692(color).method_30937()));
        }
    }

    private static int adjustAxis(int pos, int offset, int max) {
        if (pos - 4 < 0) {
            return 4;
        }
        if (pos + offset + 4 > max) {
            return max - offset - 4;
        }
        return pos;
    }

    private static class_124 getEntityColor(class_1309 entity) {
        if (entity instanceof class_1657) {
            return class_124.field_1078;
        }
        if (entity instanceof class_5354) {
            return class_124.field_1054;
        }
        if (entity.method_5864().method_5891().method_6136()) {
            return class_124.field_1060;
        }
        if (entity.method_5864().method_5891() == class_1311.field_6302) {
            return class_124.field_1061;
        }
        return class_124.field_1068;
    }

    private static void renderStack(class_332 graphics, class_1799 stack, int x, int y) {
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_51448().method_22903();
        class_308.method_24211();
        RenderSystem.enableDepthTest();
        graphics.method_51427(stack, x, y);
        graphics.method_51432(DrawOverlay.CLIENT.field_1772, stack, x, y, null);
        class_308.method_24210();
        RenderSystem.disableDepthTest();
        graphics.method_51448().method_22909();
    }

    private record TooltipDimensions(int X_OFFSET, int BASE_HEIGHT, int X_OFFSET_EXTRA, int EXTRA_HEIGHT, int WIDTH) {
    }
}

