/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public abstract class InfoTooltip {
    private static final class_2960 GUI_ICONS_LOCATION = new class_2960("textures/gui/icons.png");

    abstract int getWidth();

    abstract int getHeight();

    abstract void render(class_332 var1, int var2, int var3);

    private static void renderText(class_332 graphics, class_5684 component, int x, int y) {
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_51448().method_22903();
        component.method_32665(class_310.method_1551().field_1772, x, y, graphics.method_51448().method_23760().method_23761(), graphics.method_51450());
        graphics.method_51448().method_22909();
    }

    private static void renderIcon(class_332 graphics, int x, int y, int iconX, int iconY) {
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_51448().method_22903();
        graphics.method_25302(GUI_ICONS_LOCATION, x, y, iconX, iconY, 9, 9);
        graphics.method_51448().method_22909();
    }

    public static enum Icon {
        HEALTH_EMPTY(16, 0, 9, 9),
        HEALTH(52, 0, 9, 9),
        ARMOR(43, 9, 9, 9);

        public final int ICON_X;
        public final int ICON_Y;
        public final int ICON_WIDTH;
        public final int ICON_HEIGHT;

        private Icon(int iconX, int iconY, int iconWidth, int iconHeight) {
            this.ICON_X = iconX;
            this.ICON_Y = iconY;
            this.ICON_WIDTH = iconWidth;
            this.ICON_HEIGHT = iconHeight;
        }
    }

    static class MobStatus
    extends InfoTooltip {
        public final Map<Icon, class_5684> MOB_INFO;

        public MobStatus(Map<Icon, class_5684> map) {
            this.MOB_INFO = map;
        }

        @Override
        public int getWidth() {
            int width = 0;
            for (Map.Entry<Icon, class_5684> entry : this.MOB_INFO.entrySet()) {
                width += entry.getValue().method_32664(class_310.method_1551().field_1772) + entry.getKey().ICON_WIDTH + 4;
            }
            return width;
        }

        @Override
        public int getHeight() {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            return 9 + 1;
        }

        @Override
        void render(class_332 graphics, int x, int y) {
            int xOffset = x;
            for (Map.Entry<Icon, class_5684> entry : this.MOB_INFO.entrySet()) {
                if (entry.getKey() == Icon.HEALTH) {
                    InfoTooltip.renderIcon(graphics, xOffset, y, entry.getKey().ICON_X, entry.getKey().ICON_Y);
                }
                InfoTooltip.renderIcon(graphics, xOffset, y, entry.getKey().ICON_X, entry.getKey().ICON_Y);
                InfoTooltip.renderText(graphics, entry.getValue(), xOffset += entry.getKey().ICON_WIDTH + 2, y);
                xOffset += entry.getValue().method_32664(class_310.method_1551().field_1772) + 2;
            }
        }
    }

    static class BlockName
    extends Text {
        public BlockName(class_5684 tooltip) {
            super(tooltip);
        }

        @Override
        int getWidth() {
            return 18 + this.TOOLTIP.method_32664(class_310.method_1551().field_1772);
        }

        @Override
        public int getHeight() {
            return this.TOOLTIP.method_32661();
        }

        @Override
        void render(class_332 graphics, int x, int y) {
            InfoTooltip.renderText(graphics, this.TOOLTIP, x + 18, y);
        }
    }

    static class Text
    extends InfoTooltip {
        public final class_5684 TOOLTIP;

        public Text(class_5684 tooltip) {
            this.TOOLTIP = tooltip;
        }

        @Override
        int getWidth() {
            return this.TOOLTIP.method_32664(class_310.method_1551().field_1772);
        }

        @Override
        int getHeight() {
            return this.TOOLTIP.method_32661();
        }

        @Override
        void render(class_332 graphics, int x, int y) {
            InfoTooltip.renderText(graphics, this.TOOLTIP, x, y);
        }
    }
}

