/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.InfoTooltip;
import com.brokenkeyboard.usefulspyglass.config.ClientConfig;
import com.brokenkeyboard.usefulspyglass.platform.Services;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableInt;

public class DrawOverlay {
    private static final ConcurrentMap<String, String> MODLIST = Services.PLATFORM.getModList();
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    public static HitResult hitResult = null;

    public static void drawGUI(GuiGraphics graphics) {
        int n;
        int rectangleHeight;
        int screenWidth = CLIENT.m_91268_().m_85445_();
        int screenHeight = CLIENT.m_91268_().m_85446_();
        int xPos = (int)((double)screenWidth * (Double)ClientConfig.HUD_X.get());
        int yPos = (int)((double)screenHeight * (Double)ClientConfig.HUD_Y.get());
        ArrayList<InfoTooltip> tooltips = new ArrayList<InfoTooltip>();
        ArrayList<InfoTooltip> eventTooltips = new ArrayList<InfoTooltip>();
        TooltipDimensions dimension = DrawOverlay.createTooltips(hitResult, tooltips, eventTooltips);
        boolean isBlock = hitResult instanceof BlockHitResult && DrawOverlay.CLIENT.f_91074_ != null;
        boolean oneLine = tooltips.size() == 1;
        boolean hasExtraTooltips = !eventTooltips.isEmpty();
        int rectangleLeft = xPos - dimension.WIDTH / 2;
        int rectangleX = DrawOverlay.adjustAxis(rectangleLeft, dimension.WIDTH, screenWidth);
        int rectangleY = DrawOverlay.adjustAxis(yPos, dimension.BASE_HEIGHT + dimension.EXTRA_HEIGHT, screenHeight);
        int margin = hasExtraTooltips ? (hitResult instanceof BlockHitResult && oneLine ? 8 : 2) : 0;
        int n2 = rectangleHeight = isBlock && oneLine && !hasExtraTooltips ? 18 : dimension.BASE_HEIGHT + dimension.EXTRA_HEIGHT + margin;
        if (isBlock && oneLine) {
            Objects.requireNonNull(DrawOverlay.CLIENT.f_91062_);
            Objects.requireNonNull(DrawOverlay.CLIENT.f_91062_);
            n = rectangleY + 9 - 9 / 2;
        } else {
            n = rectangleY;
        }
        int yOffset = n;
        graphics.m_280168_().m_85836_();
        graphics.m_286007_(() -> TooltipRenderUtil.m_280205_((GuiGraphics)graphics, (int)rectangleX, (int)rectangleY, (int)dimension.WIDTH, (int)rectangleHeight, (int)400));
        if (isBlock) {
            BlockState state = DrawOverlay.CLIENT.f_91074_.m_9236_().m_8055_(((BlockHitResult)hitResult).m_82425_());
            ItemStack stack = state.m_60734_().m_7397_((BlockGetter)DrawOverlay.CLIENT.f_91074_.m_9236_(), ((BlockHitResult)hitResult).m_82425_(), state);
            int stackYPos = oneLine ? rectangleY : rectangleY + dimension.BASE_HEIGHT / 2 - 8;
            DrawOverlay.renderStack(graphics, stack, xPos - dimension.X_OFFSET, stackYPos);
        }
        for (InfoTooltip info : tooltips) {
            info.render(graphics, xPos - dimension.X_OFFSET, yOffset);
            yOffset += info.getHeight();
        }
        if (hasExtraTooltips) {
            yOffset += 4;
        }
        for (InfoTooltip info : eventTooltips) {
            info.render(graphics, xPos - dimension.X_OFFSET_EXTRA, yOffset);
            yOffset += info.getHeight();
        }
        graphics.m_280168_().m_85849_();
    }

    private static TooltipDimensions createTooltips(HitResult result, ArrayList<InfoTooltip> tooltips, ArrayList<InfoTooltip> eventTooltips) {
        Object entityHit;
        Entity entity;
        MutableInt baseWidth = new MutableInt(0);
        MutableInt baseHeight = new MutableInt(0);
        MutableInt extraWidth = new MutableInt(0);
        MutableInt extraHeight = new MutableInt(0);
        ArrayList<ClientTooltipComponent> toAdd = new ArrayList<ClientTooltipComponent>();
        if (result instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            String entityName = entity2.m_5446_().getString();
            Consumer<ClientTooltipComponent> textConsumer = tooltip -> {
                InfoTooltip.Text text = new InfoTooltip.Text((ClientTooltipComponent)tooltip);
                tooltips.add(text);
                baseHeight.add(text.getHeight());
                baseWidth.setValue(Math.max(baseWidth.getValue(), text.getWidth()));
            };
            DrawOverlay.createTextLines(textConsumer, entityName, DrawOverlay.getEntityColor(entity2));
            HashMap<InfoTooltip.Icon, ClientTooltipComponent> map = new HashMap<InfoTooltip.Icon, ClientTooltipComponent>();
            map.put(InfoTooltip.Icon.HEALTH, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)String.valueOf((int)entity2.m_21223_())).m_7532_()));
            if (entity2.m_21230_() > 0) {
                map.put(InfoTooltip.Icon.ARMOR, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)String.valueOf(entity2.m_21230_())).m_7532_()));
            }
            InfoTooltip.MobStatus status = new InfoTooltip.MobStatus(map);
            tooltips.add(status);
            baseHeight.add(status.getHeight());
            baseWidth.setValue(Math.max(baseWidth.getValue(), status.getWidth()));
            if (((Boolean)ClientConfig.DISPLAY_NAMESPACE.get()).booleanValue()) {
                namespace = (String)MODLIST.get(BuiltInRegistries.f_256780_.m_7981_((Object)entity2.m_6095_()).m_135827_());
                DrawOverlay.createTextLines(textConsumer, namespace, ChatFormatting.BLUE);
            }
            Services.PLATFORM.livingTooltipCallback(entity2, toAdd);
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            if (DrawOverlay.CLIENT.f_91074_ != null) {
                BlockPos pos = blockHit.m_82425_();
                BlockState state = DrawOverlay.CLIENT.f_91074_.m_9236_().m_8055_(pos);
                String blockName = state.m_60734_().m_49954_().getString();
                Consumer<ClientTooltipComponent> textConsumer = tooltip -> {
                    InfoTooltip.BlockName text = new InfoTooltip.BlockName((ClientTooltipComponent)tooltip);
                    tooltips.add(text);
                    baseHeight.add(((InfoTooltip.Text)text).getHeight());
                    baseWidth.setValue(Math.max(baseWidth.getValue(), ((InfoTooltip.Text)text).getWidth()));
                };
                DrawOverlay.createTextLines(textConsumer, blockName, ChatFormatting.WHITE);
                if (((Boolean)ClientConfig.DISPLAY_NAMESPACE.get()).booleanValue()) {
                    namespace = (String)MODLIST.get(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135827_());
                    DrawOverlay.createTextLines(textConsumer, namespace, ChatFormatting.BLUE);
                }
                Services.PLATFORM.blockTooltipCallback(state, pos, toAdd);
            }
        }
        for (ClientTooltipComponent component : toAdd) {
            InfoTooltip.Text text = new InfoTooltip.Text(component);
            eventTooltips.add(text);
            extraHeight.add(text.getHeight());
            extraWidth.setValue(Math.max(extraWidth.getValue(), text.getWidth()));
        }
        int xOffset = baseWidth.getValue() / 2;
        int xOffsetExtra = baseWidth.getValue() > extraWidth.getValue() ? xOffset : extraWidth.getValue() / 2;
        int width = Math.max(baseWidth.getValue(), extraWidth.getValue());
        return new TooltipDimensions(xOffset, baseHeight.getValue(), xOffsetExtra, extraHeight.getValue(), width);
    }

    private static void createTextLines(Consumer<ClientTooltipComponent> consumer, String text, ChatFormatting color) {
        String[] strings = text.split(" +");
        if (strings.length > 1) {
            int maxLength = CLIENT.m_91268_().m_85445_() / 5;
            StringBuilder str = new StringBuilder();
            for (String addStr : strings) {
                if (ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)(String.valueOf(str) + " " + addStr)).m_7532_()).m_142069_(DrawOverlay.CLIENT.f_91062_) > maxLength && !str.isEmpty()) {
                    consumer.accept(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)str.toString()).m_130940_(color).m_7532_()));
                    str = new StringBuilder();
                }
                if (!str.isEmpty()) {
                    str.append(" ");
                }
                str.append(addStr);
            }
            consumer.accept(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)str.toString()).m_130940_(color).m_7532_()));
        } else {
            consumer.accept(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)text).m_130940_(color).m_7532_()));
        }
    }

    private static int adjustAxis(int pos, int offset, int max) {
        if (pos - 4 < 0) {
            return 4;
        }
        if (pos + offset + 4 > max) {
            return max - offset - 4;
        }
        return pos;
    }

    private static ChatFormatting getEntityColor(LivingEntity entity) {
        if (entity instanceof Player) {
            return ChatFormatting.BLUE;
        }
        if (entity instanceof NeutralMob) {
            return ChatFormatting.YELLOW;
        }
        if (entity.m_6095_().m_20674_().m_21609_()) {
            return ChatFormatting.GREEN;
        }
        if (entity.m_6095_().m_20674_() == MobCategory.MONSTER) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.WHITE;
    }

    private static void renderStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85836_();
        Lighting.m_84931_();
        RenderSystem.enableDepthTest();
        graphics.m_280480_(stack, x, y);
        graphics.m_280302_(DrawOverlay.CLIENT.f_91062_, stack, x, y, null);
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85849_();
    }

    private record TooltipDimensions(int X_OFFSET, int BASE_HEIGHT, int X_OFFSET_EXTRA, int EXTRA_HEIGHT, int WIDTH) {
    }
}

