/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class InfoTooltip {
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");

    abstract int getWidth();

    abstract int getHeight();

    abstract void render(GuiGraphics var1, int var2, int var3);

    private static void renderText(GuiGraphics graphics, ClientTooltipComponent component, int x, int y) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85836_();
        component.m_142440_(Minecraft.m_91087_().f_91062_, x, y, graphics.m_280168_().m_85850_().m_252922_(), graphics.m_280091_());
        graphics.m_280168_().m_85849_();
    }

    private static void renderIcon(GuiGraphics graphics, int x, int y, int iconX, int iconY) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280218_(GUI_ICONS_LOCATION, x, y, iconX, iconY, 9, 9);
        graphics.m_280168_().m_85849_();
    }

    public static enum Icon {
        HEALTH_EMPTY(16, 0, 9, 9),
        HEALTH(52, 0, 9, 9),
        ARMOR(43, 9, 9, 9);

        public final int ICON_X;
        public final int ICON_Y;
        public final int ICON_WIDTH;
        public final int ICON_HEIGHT;

        private Icon(int iconX, int iconY, int iconWidth, int iconHeight) {
            this.ICON_X = iconX;
            this.ICON_Y = iconY;
            this.ICON_WIDTH = iconWidth;
            this.ICON_HEIGHT = iconHeight;
        }
    }

    static class MobStatus
    extends InfoTooltip {
        public final Map<Icon, ClientTooltipComponent> MOB_INFO;

        public MobStatus(Map<Icon, ClientTooltipComponent> map) {
            this.MOB_INFO = map;
        }

        @Override
        public int getWidth() {
            int width = 0;
            for (Map.Entry<Icon, ClientTooltipComponent> entry : this.MOB_INFO.entrySet()) {
                width += entry.getValue().m_142069_(Minecraft.m_91087_().f_91062_) + entry.getKey().ICON_WIDTH + 4;
            }
            return width;
        }

        @Override
        public int getHeight() {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return 9 + 1;
        }

        @Override
        void render(GuiGraphics graphics, int x, int y) {
            int xOffset = x;
            for (Map.Entry<Icon, ClientTooltipComponent> entry : this.MOB_INFO.entrySet()) {
                if (entry.getKey() == Icon.HEALTH) {
                    InfoTooltip.renderIcon(graphics, xOffset, y, entry.getKey().ICON_X, entry.getKey().ICON_Y);
                }
                InfoTooltip.renderIcon(graphics, xOffset, y, entry.getKey().ICON_X, entry.getKey().ICON_Y);
                InfoTooltip.renderText(graphics, entry.getValue(), xOffset += entry.getKey().ICON_WIDTH + 2, y);
                xOffset += entry.getValue().m_142069_(Minecraft.m_91087_().f_91062_) + 2;
            }
        }
    }

    static class BlockName
    extends Text {
        public BlockName(ClientTooltipComponent tooltip) {
            super(tooltip);
        }

        @Override
        int getWidth() {
            return 18 + this.TOOLTIP.m_142069_(Minecraft.m_91087_().f_91062_);
        }

        @Override
        public int getHeight() {
            return this.TOOLTIP.m_142103_();
        }

        @Override
        void render(GuiGraphics graphics, int x, int y) {
            InfoTooltip.renderText(graphics, this.TOOLTIP, x + 18, y);
        }
    }

    static class Text
    extends InfoTooltip {
        public final ClientTooltipComponent TOOLTIP;

        public Text(ClientTooltipComponent tooltip) {
            this.TOOLTIP = tooltip;
        }

        @Override
        int getWidth() {
            return this.TOOLTIP.m_142069_(Minecraft.m_91087_().f_91062_);
        }

        @Override
        int getHeight() {
            return this.TOOLTIP.m_142103_();
        }

        @Override
        void render(GuiGraphics graphics, int x, int y) {
            InfoTooltip.renderText(graphics, this.TOOLTIP, x, y);
        }
    }
}

