/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.mixin.EntityAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MarkedEntities {
    private final Map<UUID, Integer> MARKED_ENTITIES = new HashMap<UUID, Integer>();
    private final ServerPlayer PLAYER;
    private int tickCount;

    public MarkedEntities(ServerPlayer player) {
        this.PLAYER = player;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.MARKED_ENTITIES.isEmpty()) {
            Iterator<Map.Entry<UUID, Integer>> iterator = this.MARKED_ENTITIES.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Integer> entry = iterator.next();
                if (entry.getValue() > this.tickCount) continue;
                Entity entity = this.PLAYER.m_284548_().m_8791_(entry.getKey());
                iterator.remove();
                if (entity == null) continue;
                this.PLAYER.f_8906_.m_9829_((Packet)this.createPacket(entity, false));
            }
        }
    }

    public void addEntity(Entity entity, int ticks) {
        this.MARKED_ENTITIES.put(entity.m_20148_(), this.tickCount + ticks);
        this.PLAYER.f_8906_.m_9829_((Packet)this.createPacket(entity, true));
    }

    public ClientboundSetEntityDataPacket createPacket(Entity entity, boolean shouldGlow) {
        byte entityData = (Byte)entity.m_20088_().m_135370_(EntityAccessor.getDATA_SHARED_FLAGS_ID());
        byte isGlowing = (byte)(shouldGlow ? entityData | 1 << EntityAccessor.getFLAG_GLOWING() : entityData & ~(1 << EntityAccessor.getFLAG_GLOWING()));
        List original = entity.m_20088_().m_252804_();
        List packedItems = original != null ? original : new ArrayList();
        packedItems.add(new SynchedEntityData.DataValue(EntityAccessor.getDATA_SHARED_FLAGS_ID().hashCode(), EntityAccessor.getDATA_SHARED_FLAGS_ID().m_135016_(), (Object)isGlowing));
        return new ClientboundSetEntityDataPacket(entity.m_19879_(), packedItems);
    }

    public Map<UUID, Integer> getMarkedEntities() {
        return this.MARKED_ENTITIES;
    }
}

