/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.DrawOverlay;
import com.brokenkeyboard.usefulspyglass.ModRegistry;
import com.brokenkeyboard.usefulspyglass.config.ClientConfig;
import com.brokenkeyboard.usefulspyglass.config.CommonConfig;
import com.brokenkeyboard.usefulspyglass.handler.ClientHandler;
import com.brokenkeyboard.usefulspyglass.network.PacketHandler;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;

@Mod(value="usefulspyglass")
public class UsefulSpyglass {
    public static final ArrayList<Predicate<?>> PRECISION_COMPATIBLE = new ArrayList();
    public static final String IMC_ID = "precision";
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"usefulspyglass");
    public static final Supplier<EntityType<?>> WATCHER_EYE = ENTITIES.register("watcher_eye", () -> ModRegistry.SPOTTER_EYE);

    public UsefulSpyglass(FMLJavaModLoadingContext context) {
        IEventBus bus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ENTITIES.register(bus);
        UsefulSpyglass.register(context, Registries.f_256762_, ModRegistry::registerEnchantment);
        bus.addListener(this::imcProcess);
    }

    public void imcProcess(InterModProcessEvent event) {
        event.getIMCStream().forEach(imcMessage -> {
            Object patt2927$temp;
            if (imcMessage.method().equals(IMC_ID) && (patt2927$temp = imcMessage.messageSupplier().get()) instanceof Predicate) {
                Predicate predicate = (Predicate)patt2927$temp;
                PRECISION_COMPATIBLE.add(predicate);
            }
        });
    }

    public static <T> void register(FMLJavaModLoadingContext context, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<ResourceLocation, T>> source) {
        context.getModEventBus().addListener(event -> source.accept((location, supplier) -> event.register(registry, location, () -> supplier)));
    }

    @Mod.EventBusSubscriber(modid="usefulspyglass", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ClientHandler.handleClientTick(Minecraft.m_91087_());
        }
    }

    @Mod.EventBusSubscriber(modid="usefulspyglass")
    public static class Events {
        @SubscribeEvent
        public static void livingDamage(LivingDamageEvent event) {
            Projectile projectile;
            Entity entity;
            if (event.getSource().m_269533_(DamageTypeTags.f_268524_) && (entity = event.getSource().m_7640_()) instanceof Projectile && (projectile = (Projectile)entity).m_19880_().contains(UsefulSpyglass.IMC_ID)) {
                event.setAmount(event.getAmount() * 1.2f);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="usefulspyglass", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientRegistryEvents {
        @SubscribeEvent
        public static void registerGUI(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.DEBUG_TEXT.id(), "hud_base", (gui, graphics, partialTick, width, height) -> {
                gui.setupOverlayRenderState(true, false);
                if ((!ModList.get().isLoaded("jade") || !((Boolean)ClientConfig.JADE_INTEGRATION.get()).booleanValue()) && (DrawOverlay.hitResult instanceof EntityHitResult && ((Boolean)ClientConfig.DISPLAY_ENTITIES.get()).booleanValue() || DrawOverlay.hitResult instanceof BlockHitResult && ((Boolean)ClientConfig.DISPLAY_BLOCKS.get()).booleanValue())) {
                    DrawOverlay.drawGUI(graphics);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(modid="usefulspyglass", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            event.enqueueWork(PacketHandler::register);
        }
    }
}

