/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass.platform;

import com.brokenkeyboard.usefulspyglass.Curios;
import com.brokenkeyboard.usefulspyglass.EntityFinder;
import com.brokenkeyboard.usefulspyglass.ModRegistry;
import com.brokenkeyboard.usefulspyglass.UsefulSpyglass;
import com.brokenkeyboard.usefulspyglass.api.event.BlockTooltipEvent;
import com.brokenkeyboard.usefulspyglass.api.event.LivingTooltipEvent;
import com.brokenkeyboard.usefulspyglass.handler.ServerHandler;
import com.brokenkeyboard.usefulspyglass.network.PacketHandler;
import com.brokenkeyboard.usefulspyglass.platform.IPlatformHelper;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public EnchantmentCategory getSpyglassEnchCategory() {
        return EnchantmentCategory.create((String)"spyglass", item -> item instanceof SpyglassItem);
    }

    @Override
    public boolean hasSpyglassEnchant(Player player, Enchantment enchantment) {
        ItemStack stack = player.m_21211_();
        Predicate<ItemStack> predicate = stack1 -> stack1.m_41720_() == Items.f_151059_ && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack1) > 0;
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack) > 0 || ModList.get().isLoaded("curios") && Curios.checkCurios(player, predicate) && !ServerHandler.usingPrecision(player) && stack.m_41720_() != Items.f_151059_;
    }

    @Override
    public boolean hasPrecision(Player player) {
        Predicate<ItemStack> predicate = stack1 -> stack1.m_41720_() == Items.f_151059_ && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)ModRegistry.PRECISION, (ItemStack)stack1) > 0;
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)ModRegistry.PRECISION, (ItemStack)player.m_21120_(InteractionHand.OFF_HAND)) > 0 || ModList.get().isLoaded("curios") && Curios.checkCurios(player, predicate);
    }

    @Override
    public boolean testPrecisionCompat(Player player) {
        for (Predicate<?> predicate : UsefulSpyglass.PRECISION_COMPATIBLE) {
            try {
                if (!predicate.test(player)) continue;
                return true;
            }
            catch (ClassCastException exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public HitResult getHitResult(Camera camera, float partialTick, Player player) {
        if (ModList.get().isLoaded("shouldersurfing") && ShoulderSurfing.getInstance().isShoulderSurfing()) {
            PickContext pickContext = new PickContext.Builder(camera).withEntity((Entity)player).withFluidContext(ClipContext.Fluid.NONE).build();
            return ShoulderSurfing.getInstance().getObjectPicker().pick(pickContext, 100.0, partialTick, Minecraft.m_91087_().f_91072_);
        }
        return EntityFinder.getAimedObject(player.m_9236_(), camera.m_90592_(), camera.m_90583_(), camera.m_90592_().m_20252_(partialTick));
    }

    @Override
    public void useSpyglassEnch() {
        PacketHandler.sendSpyglassPacket();
    }

    @Override
    public void livingTooltipCallback(LivingEntity entity, List<ClientTooltipComponent> eventTooltips) {
        LivingTooltipEvent event = new LivingTooltipEvent(entity, eventTooltips);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public void blockTooltipCallback(BlockState state, BlockPos pos, List<ClientTooltipComponent> tooltipInfoList) {
        BlockTooltipEvent event = new BlockTooltipEvent(state, pos, tooltipInfoList);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public ConcurrentMap<String, String> getModList() {
        ConcurrentMap map = Maps.newConcurrentMap();
        List list = ModList.get().getMods();
        for (IModInfo mod : list) {
            String modid = mod.getModId();
            String name = mod.getDisplayName() != null ? mod.getDisplayName() : modid;
            map.put(modid, name);
        }
        return map;
    }
}

