/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.behaviors;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.util.GenericContainerHelper;
import appeng.util.fluid.FluidSoundHelper;
import com.google.common.primitives.Ints;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

class FluidContainerItemStrategy
implements ContainerItemStrategy<AEFluidKey, Context> {
    FluidContainerItemStrategy() {
    }

    @Override
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        return GenericContainerHelper.getContainedFluidStack(stack);
    }

    @Override
    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        if (menu.m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return new CarriedContext(player, menu);
        }
        return null;
    }

    @Override
    @Nullable
    public Context findPlayerSlotContext(Player player, int slot) {
        if (player.m_150109_().m_8020_(slot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return new PlayerInvContext(player, slot);
        }
        return null;
    }

    @Override
    public long extract(Context context, AEFluidKey what, long amount, Actionable mode) {
        ItemStack stack = context.getStack();
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (fluidHandler == null) {
            return 0L;
        }
        int extracted = fluidHandler.drain(what.toStack(Ints.saturatedCast((long)amount)), mode.getFluidAction()).getAmount();
        if (mode == Actionable.MODULATE) {
            stack.m_41774_(1);
            context.addOverflow(fluidHandler.getContainer());
        }
        return extracted;
    }

    @Override
    public long insert(Context context, AEFluidKey what, long amount, Actionable mode) {
        ItemStack stack = context.getStack();
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (fluidHandler == null) {
            return 0L;
        }
        int filled = fluidHandler.fill(what.toStack(Ints.saturatedCast((long)amount)), mode.getFluidAction());
        if (mode == Actionable.MODULATE) {
            stack.m_41774_(1);
            context.addOverflow(fluidHandler.getContainer());
        }
        return filled;
    }

    @Override
    public void playFillSound(Player player, AEFluidKey what) {
        FluidSoundHelper.playFillSound(player, what);
    }

    @Override
    public void playEmptySound(Player player, AEFluidKey what) {
        FluidSoundHelper.playEmptySound(player, what);
    }

    @Override
    @Nullable
    public GenericStack getExtractableContent(Context context) {
        return this.getContainedStack(context.getStack());
    }

    private record CarriedContext(Player player, AbstractContainerMenu menu) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.menu.m_142621_();
        }

        @Override
        public void setStack(ItemStack stack) {
            this.menu.m_142503_(stack);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            if (this.menu.m_142621_().m_41619_()) {
                this.menu.m_142503_(stack);
            } else {
                this.player.m_150109_().m_150079_(stack);
            }
        }
    }

    private record PlayerInvContext(Player player, int slot) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.player.m_150109_().m_8020_(this.slot);
        }

        @Override
        public void setStack(ItemStack stack) {
            this.player.m_150109_().m_6836_(this.slot, stack);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            this.player.m_150109_().m_150079_(stack);
        }
    }

    static interface Context {
        public ItemStack getStack();

        public void setStack(ItemStack var1);

        public void addOverflow(ItemStack var1);
    }
}

