/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.BaseOption;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Objects;

public class StringOption
extends BaseOption {
    private final String defaultValue;
    private String currentValue;

    public StringOption(ConfigSection parent, String id, String comment, String defaultValue) {
        super(parent, id, comment);
        this.currentValue = this.defaultValue = defaultValue;
    }

    public String get() {
        return this.currentValue;
    }

    public void set(String value) {
        Objects.requireNonNull(value);
        if (value.equals(this.currentValue)) {
            return;
        }
        this.currentValue = value;
        this.parent.markDirty();
    }

    @Override
    protected JsonElement write() {
        return new JsonPrimitive(this.currentValue);
    }

    @Override
    protected void read(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            throw new ConfigValidationException(this, "Expected a JSON primitive: " + String.valueOf(element));
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isString()) {
            throw new ConfigValidationException(this, "Expected a JSON string, but found: " + String.valueOf(primitive));
        }
        this.currentValue = primitive.getAsString();
    }

    @Override
    public boolean isDifferentFromDefault() {
        return !this.currentValue.equals(this.defaultValue);
    }

    @Override
    public String getDefaultAsString() {
        return this.defaultValue;
    }

    @Override
    public String getCurrentValueAsString() {
        return this.currentValue;
    }
}

