/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.PatternProviderLockReason;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigButtonPacket;
import appeng.menu.implementations.PatternProviderMenu;
import net.minecraft.class_1661;
import net.minecraft.class_2561;

public class PatternProviderScreen<C extends PatternProviderMenu>
extends AEBaseScreen<C> {
    private final SettingToggleButton<YesNo> blockingModeButton = new ServerSettingToggleButton<YesNo>(Settings.BLOCKING_MODE, YesNo.NO);
    private final SettingToggleButton<LockCraftingMode> lockCraftingModeButton;
    private final ToggleButton showInPatternAccessTerminalButton;
    private final PatternProviderLockReason lockReason;

    public PatternProviderScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.addToLeftToolbar(this.blockingModeButton);
        this.lockCraftingModeButton = new ServerSettingToggleButton<LockCraftingMode>(Settings.LOCK_CRAFTING_MODE, LockCraftingMode.NONE);
        this.addToLeftToolbar(this.lockCraftingModeButton);
        this.widgets.addOpenPriorityButton();
        this.showInPatternAccessTerminalButton = new ToggleButton(Icon.PATTERN_ACCESS_SHOW, Icon.PATTERN_ACCESS_HIDE, (class_2561)GuiText.PatternAccessTerminal.text(), (class_2561)GuiText.PatternAccessTerminalHint.text(), btn -> this.selectNextPatternProviderMode());
        this.addToLeftToolbar(this.showInPatternAccessTerminalButton);
        this.lockReason = new PatternProviderLockReason(this);
        this.widgets.add("lockReason", this.lockReason);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.lockReason.setVisible(((PatternProviderMenu)this.field_2797).getLockCraftingMode() != LockCraftingMode.NONE);
        this.blockingModeButton.set(((PatternProviderMenu)this.field_2797).getBlockingMode());
        this.lockCraftingModeButton.set(((PatternProviderMenu)this.field_2797).getLockCraftingMode());
        this.showInPatternAccessTerminalButton.setState(((PatternProviderMenu)this.field_2797).getShowInAccessTerminal() == YesNo.YES);
    }

    private void selectNextPatternProviderMode() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigButtonPacket(Settings.PATTERN_ACCESS_TERMINAL, backwards));
    }
}

