/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.flow;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.LytSize;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytVisitor;
import appeng.client.guidebook.document.flow.InlineBlockAlignment;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.screen.GuideScreen;
import java.util.Optional;

public class LytFlowInlineBlock
extends LytFlowContent
implements InteractiveElement {
    private LytBlock block;
    private InlineBlockAlignment alignment = InlineBlockAlignment.INLINE;

    public LytBlock getBlock() {
        return this.block;
    }

    public void setBlock(LytBlock block) {
        this.block = block;
    }

    public InlineBlockAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(InlineBlockAlignment alignment) {
        this.alignment = alignment;
    }

    public LytSize getPreferredSize(int lineWidth) {
        if (this.block == null) {
            return LytSize.empty();
        }
        LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
        LytRect bounds = this.block.layout(layoutContext, 0, 0, lineWidth);
        return new LytSize(bounds.right(), bounds.bottom());
    }

    @Override
    public boolean mouseClicked(GuideScreen screen, int x, int y, int button) {
        LytBlock lytBlock = this.block;
        if (lytBlock instanceof InteractiveElement) {
            InteractiveElement interactiveElement = (InteractiveElement)((Object)lytBlock);
            return interactiveElement.mouseClicked(screen, x, y, button);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(GuideScreen screen, int x, int y, int button) {
        LytBlock lytBlock = this.block;
        if (lytBlock instanceof InteractiveElement) {
            InteractiveElement interactiveElement = (InteractiveElement)((Object)lytBlock);
            return interactiveElement.mouseReleased(screen, x, y, button);
        }
        return false;
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        LytBlock lytBlock = this.block;
        if (lytBlock instanceof InteractiveElement) {
            InteractiveElement interactiveElement = (InteractiveElement)((Object)lytBlock);
            return interactiveElement.getTooltip(x, y);
        }
        return Optional.empty();
    }

    @Override
    protected void visitChildren(LytVisitor visitor) {
        if (this.block != null) {
            this.block.visit(visitor);
        }
    }

    public static LytFlowInlineBlock of(LytBlock block) {
        LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
        inlineBlock.setBlock(block);
        return inlineBlock;
    }
}

