/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.mdast.mdx.model;

import appeng.libs.mdast.mdx.model.MdxJsxAttribute;
import appeng.libs.mdast.mdx.model.MdxJsxAttributeNode;
import appeng.libs.mdast.mdx.model.MdxJsxExpressionAttribute;
import appeng.libs.mdast.model.MdAstAnyContent;
import appeng.libs.unist.UnistNode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface MdxJsxElementFields
extends UnistNode {
    @Nullable
    public String name();

    public void setName(String var1);

    public List<MdxJsxAttributeNode> attributes();

    public List<? extends MdAstAnyContent> children();

    default public boolean hasAttribute(String name) {
        for (MdxJsxAttributeNode attributeNode : this.attributes()) {
            if (attributeNode instanceof MdxJsxAttribute) {
                MdxJsxAttribute jsxAttribute = (MdxJsxAttribute)attributeNode;
                if (!name.equals(jsxAttribute.name)) continue;
                return true;
            }
            if (!(attributeNode instanceof MdxJsxExpressionAttribute)) continue;
            MdxJsxExpressionAttribute jsxExpressionAttribute = (MdxJsxExpressionAttribute)attributeNode;
            throw new IllegalStateException("Attribute spreads unsupported!");
        }
        return false;
    }

    default public String getAttributeString(String name, String defaultValue) {
        MdxJsxAttribute jsxAttribute = this.getAttribute(name);
        return jsxAttribute != null ? jsxAttribute.getStringValue() : defaultValue;
    }

    default public void setAttribute(String name, String value) {
        for (MdxJsxAttributeNode attribute : this.attributes()) {
            if (!(attribute instanceof MdxJsxAttribute)) continue;
            MdxJsxAttribute attr = (MdxJsxAttribute)attribute;
            if (!name.equals(attr.name)) continue;
            attr.setValue(value);
            return;
        }
        this.addAttribute(name, value);
    }

    default public void addAttribute(String name, String value) {
        this.attributes().add(new MdxJsxAttribute(name, value));
    }

    default public void addAttribute(String name, int value) {
        MdxJsxAttribute attr = new MdxJsxAttribute();
        attr.name = name;
        attr.setExpression(Integer.toString(value));
        this.attributes().add(attr);
    }

    default public void addAttribute(String name, float value) {
        MdxJsxAttribute attr = new MdxJsxAttribute();
        attr.name = name;
        attr.setExpression(Float.toString(value));
        this.attributes().add(attr);
    }

    default public void addAttribute(String name, boolean value) {
        MdxJsxAttribute attr = new MdxJsxAttribute();
        attr.name = name;
        attr.setExpression(Boolean.toString(value));
        this.attributes().add(attr);
    }

    @Nullable
    default public MdxJsxAttribute getAttribute(String name) {
        for (MdxJsxAttributeNode attributeNode : this.attributes()) {
            if (attributeNode instanceof MdxJsxAttribute) {
                MdxJsxAttribute jsxAttribute = (MdxJsxAttribute)attributeNode;
                if (!name.equals(jsxAttribute.name)) continue;
                return jsxAttribute;
            }
            if (!(attributeNode instanceof MdxJsxExpressionAttribute)) continue;
            MdxJsxExpressionAttribute jsxExpressionAttribute = (MdxJsxExpressionAttribute)attributeNode;
            throw new IllegalStateException("Attribute spreads unsupported!");
        }
        return null;
    }
}

