/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.storagebus;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.core.stats.AdvancementTriggers;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.helpers.InterfaceLogicHost;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.CompositeStorage;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.NullInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.StorageBusMenu;
import appeng.menu.locator.MenuLocators;
import appeng.parts.PartAdjacentApi;
import appeng.parts.PartModel;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class StorageBusPart
extends UpgradeablePart
implements IGridTickable,
IStorageProvider,
IPriorityHost,
IConfigInvHost {
    public static final class_2960 MODEL_BASE = new class_2960("ae2", "part/storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("ae2", "part/storage_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("ae2", "part/storage_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("ae2", "part/storage_bus_has_channel"));
    protected final IActionSource source;
    private final ConfigInventory config = ConfigInventory.configTypes(63, this::onConfigurationChanged);
    private final StorageBusInventory handler = new StorageBusInventory(NullInventory.of());
    @Nullable
    private class_2561 handlerDescription;
    private final PartAdjacentApi<MEStorage> adjacentStorageAccessor;
    @Nullable
    private Map<AEKeyType, ExternalStorageStrategy> externalStorageStrategies;
    private boolean wasOnline = false;
    private int priority = 0;
    private PendingUpdateStatus updateStatus = PendingUpdateStatus.FAST_UPDATE;
    private ITickingMonitor monitor = null;

    public StorageBusPart(IPartItem<?> partItem) {
        super(partItem);
        this.adjacentStorageAccessor = new PartAdjacentApi<MEStorage>(this, MEStorage.SIDED);
        this.getConfigManager().registerSetting(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.getConfigManager().registerSetting(Settings.FILTER_ON_EXTRACT, YesNo.YES);
        this.source = new MachineSource(this);
        this.getMainNode().addService(IStorageProvider.class, this).addService(IGridTickable.class, this);
    }

    @Override
    protected final void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.getHost().markForUpdate();
            this.remountStorage();
        }
    }

    private void remountStorage() {
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.onConfigurationChanged();
        this.getHost().markForSave();
    }

    @Override
    public final void upgradesChanged() {
        super.upgradesChanged();
        this.onConfigurationChanged();
    }

    private void scheduleUpdate() {
        if (this.isClientSide()) {
            return;
        }
        this.updateStatus = PendingUpdateStatus.FAST_UPDATE;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.priority = data.method_10550("priority");
        this.config.readFromChildTag(data, "config");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10569("priority", this.priority);
        this.config.writeToChildTag(data, "config");
    }

    @Override
    public final boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    protected final void openConfigMenu(class_1657 player) {
        MenuOpener.open(this.getMenuType(), player, MenuLocators.forPart(this));
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(this.getMenuType(), player, MenuLocators.forPart(this));
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return new class_1799(this.getPartItem());
    }

    public class_3917<?> getMenuType() {
        return StorageBusMenu.TYPE;
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    protected final int getUpgradeSlots() {
        return 5;
    }

    @Override
    public final float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    @Override
    public final void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide()).equals((Object)neighbor)) {
            class_2586 te = level.method_8321(neighbor);
            if (te == null) {
                this.updateTarget(false);
            } else {
                this.scheduleUpdate();
            }
        }
    }

    @Override
    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus, false, true);
    }

    @Override
    public final TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.updateStatus != PendingUpdateStatus.NO_UPDATE) {
            this.updateTarget(false);
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return this.updateStatus == PendingUpdateStatus.SLOW_UPDATE ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
    }

    public MEStorage getInternalHandler() {
        return this.handler.getDelegate();
    }

    private boolean hasRegisteredCellToNetwork() {
        return this.getMainNode().isOnline() && !(this.handler.getDelegate() instanceof NullInventory);
    }

    public class_2561 getConnectedToDescription() {
        return this.handlerDescription;
    }

    protected void onConfigurationChanged() {
        if (this.getMainNode().isReady()) {
            this.updateTarget(true);
        }
    }

    private void updateTarget(boolean forceFullUpdate) {
        ITickingMonitor tickingMonitor;
        MEStorage newInventory;
        MEStorage mEStorage;
        if (this.isClientSide()) {
            return;
        }
        MEStorage foundMonitor = null;
        Map<AEKeyType, MEStorage> foundExternalApi = Collections.emptyMap();
        if (Platform.areBlockEntitiesTicking(this.getLevel(), this.getBlockEntity().method_11016().method_10093(this.getSide()))) {
            this.updateStatus = PendingUpdateStatus.NO_UPDATE;
            foundMonitor = this.adjacentStorageAccessor.find();
            if (foundMonitor == null) {
                foundExternalApi = new IdentityHashMap(2);
                this.findExternalStorages(foundExternalApi);
            }
        } else {
            this.updateStatus = PendingUpdateStatus.SLOW_UPDATE;
        }
        if (!forceFullUpdate && (mEStorage = this.handler.getDelegate()) instanceof CompositeStorage) {
            CompositeStorage compositeStorage = (CompositeStorage)mEStorage;
            if (!foundExternalApi.isEmpty()) {
                compositeStorage.setStorages(foundExternalApi);
                this.handlerDescription = compositeStorage.getDescription();
                return;
            }
        }
        if (!forceFullUpdate && foundMonitor == this.handler.getDelegate()) {
            return;
        }
        boolean wasSleeping = this.monitor == null;
        boolean wasRegistered = this.hasRegisteredCellToNetwork();
        if (foundMonitor != null) {
            newInventory = foundMonitor;
            this.checkStorageBusOnInterface();
            this.handlerDescription = newInventory.getDescription();
        } else if (!foundExternalApi.isEmpty()) {
            newInventory = new CompositeStorage(foundExternalApi);
            this.handlerDescription = newInventory.getDescription();
        } else {
            newInventory = NullInventory.of();
            this.handlerDescription = null;
        }
        this.handler.setDelegate(newInventory);
        this.handler.setAccessRestriction(this.getConfigManager().getSetting(Settings.ACCESS));
        this.handler.setWhitelist(this.isUpgradedWith(AEItems.INVERTER_CARD) ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.handler.setPartitionList(this.createFilter());
        this.handler.setVoidOverflow(this.isUpgradedWith(AEItems.VOID_CARD));
        boolean filterOnExtract = this.getConfigManager().getSetting(Settings.FILTER_ON_EXTRACT) == YesNo.YES;
        this.handler.setExtractFiltering(filterOnExtract, this.isExtractableOnly() && filterOnExtract);
        this.monitor = newInventory instanceof ITickingMonitor ? (tickingMonitor = (ITickingMonitor)((Object)newInventory)) : null;
        if (wasSleeping != (this.monitor == null)) {
            this.getMainNode().ifPresent((grid, node) -> {
                ITickManager tm = grid.getTickManager();
                if (this.monitor == null) {
                    tm.sleepDevice((IGridNode)node);
                } else {
                    tm.wakeDevice((IGridNode)node);
                }
            });
        }
        if (wasRegistered != this.hasRegisteredCellToNetwork()) {
            this.remountStorage();
        }
    }

    private boolean isExtractableOnly() {
        return this.getConfigManager().getSetting(Settings.STORAGE_FILTER) == StorageFilter.EXTRACTABLE_ONLY;
    }

    private IPartitionList createFilter() {
        IPartitionList.Builder filterBuilder = IPartitionList.builder();
        if (this.isUpgradedWith(AEItems.FUZZY_CARD)) {
            filterBuilder.fuzzyMode(this.getConfigManager().getSetting(Settings.FUZZY_MODE));
        }
        int slotsToUse = 18 + this.getInstalledUpgrades(AEItems.CAPACITY_CARD) * 9;
        for (int x = 0; x < this.config.size() && x < slotsToUse; ++x) {
            filterBuilder.add(this.config.getKey(x));
        }
        return filterBuilder.build();
    }

    private void findExternalStorages(Map<AEKeyType, MEStorage> storages) {
        boolean extractableOnly = this.isExtractableOnly();
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.getExternalStorageStrategies().entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(extractableOnly, this::invalidateOnExternalStorageChange);
            if (wrapper == null) continue;
            storages.put(entry.getKey(), wrapper);
        }
    }

    private void invalidateOnExternalStorageChange() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
    }

    private void checkStorageBusOnInterface() {
        MinecraftServer server;
        class_3222 player;
        class_2586 targetBe;
        class_2350 oppositeSide = this.getSide().method_10153();
        class_2338 targetPos = this.getBlockEntity().method_11016().method_10093(this.getSide());
        Object targetHost = targetBe = this.getLevel().method_8321(targetPos);
        if (targetBe instanceof IPartHost) {
            IPartHost partHost = (IPartHost)targetBe;
            targetHost = partHost.getPart(oppositeSide);
        }
        if (targetHost instanceof InterfaceLogicHost && (player = IPlayerRegistry.getConnected(server = this.getLevel().method_8503(), this.getActionableNode().getOwningPlayerId())) != null) {
            AdvancementTriggers.RECURSIVE.trigger(player);
        }
    }

    @Override
    public void mountInventories(IStorageMounts mounts) {
        if (this.hasRegisteredCellToNetwork()) {
            mounts.mount(this.handler, this.priority);
        }
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.remountStorage();
    }

    @Override
    public ConfigInventory getConfig() {
        return this.config;
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        this.config.readFromChildTag(input, "config");
    }

    @Override
    public void exportSettings(SettingsFrom mode, class_2487 output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.config.writeToChildTag(output, "config");
        }
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    private Map<AEKeyType, ExternalStorageStrategy> getExternalStorageStrategies() {
        if (this.externalStorageStrategies == null) {
            class_2586 host = this.getHost().getBlockEntity();
            this.externalStorageStrategies = StackWorldBehaviors.createExternalStorageStrategies((class_3218)host.method_10997(), host.method_11016().method_10093(this.getSide()), this.getSide().method_10153());
        }
        return this.externalStorageStrategies;
    }

    private static class StorageBusInventory
    extends MEInventoryHandler {
        public StorageBusInventory(MEStorage inventory) {
            super(inventory);
        }

        @Override
        protected MEStorage getDelegate() {
            return super.getDelegate();
        }

        @Override
        protected void setDelegate(MEStorage delegate) {
            super.setDelegate(delegate);
        }

        public void setAccessRestriction(AccessRestriction setting) {
            this.setAllowExtraction(setting.isAllowExtraction());
            this.setAllowInsertion(setting.isAllowInsertion());
        }
    }

    private static enum PendingUpdateStatus {
        FAST_UPDATE,
        SLOW_UPDATE,
        NO_UPDATE;

    }
}

