package com.github.wyzzard225.reference_image_overlay.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class ConfigManager {
	 private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
	 private static final File CONFIG_FILE =
					 new File("config/reference_image_overlay.json");

	 public static boolean load() {
			if (CONFIG_FILE.exists()) {
				 try (FileReader reader = new FileReader(CONFIG_FILE)) {
						Settings.INSTANCE =
										GSON.fromJson(reader, Settings.class);
				 } catch (IOException e) {
						Reference_image_overlayClient.console.error("[ReferenceImageOverlay] Failed to load config: "+ Arrays.toString(e.getStackTrace()));
				 }
				 return true;
			}
			return false;
	 }

	 public static void save() {
			Settings.INSTANCE.loadImages();
			Reference_image_overlayClient.console.info("[ReferenceImageOverlay] Saved Config!");
			try (FileWriter writer = new FileWriter(CONFIG_FILE)) {
				 GSON.toJson(Settings.INSTANCE, writer);
			} catch (IOException e) {
				 Reference_image_overlayClient.console.error("[ReferenceImageOverlay] Failed to save config: "+ Arrays.toString(e.getStackTrace()));
			}
	 }
}