package com.github.wyzzard225.reference_image_overlay.client;

import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.class_2960;

import static com.github.wyzzard225.reference_image_overlay.client.Reference_image_overlayClient.console;

public class Settings {
	 public enum ImageNum {
			NONE,
			IMAGE_1,
			IMAGE_2,
			IMAGE_3,
			IMAGE_4,
			IMAGE_5,
			IMAGE_6,
			IMAGE_7,
			IMAGE_8,
			IMAGE_9,
			IMAGE_10
	 }

	 public ImageNum image1Num;
	 public ImageNum image2Num;
	 public HashMap<String, Integer> image1Pos = new HashMap<>();
	 public HashMap<String, Integer> image2Pos = new HashMap<>();
	 public final class_2960[] imagesLoaded = new class_2960[10];
	 public final String[] imageUrls = new String[10];

	 public static Settings INSTANCE = new Settings();
	 public static final Settings defaultSettings = new Settings().resetSettings();

	 public Settings() {}

	 public Settings resetSettings() {
			image1Num = ImageNum.IMAGE_1;
			image2Num = ImageNum.IMAGE_2;
			image1Pos = HashMap.newHashMap(4);
			image1Pos.put("x", 10);
			image1Pos.put("y", 10);
			image1Pos.put("width", 128);
			image1Pos.put("height", 128);
			image2Pos = HashMap.newHashMap(4);
			image2Pos.put("x",10);
			image2Pos.put("y",148);
			image2Pos.put("width",128);
			image2Pos.put("height",128);

			Arrays.fill(imageUrls, "");
			Arrays.fill(imagesLoaded, class_2960.method_60655("reference_image_overlay","textures/gui/null_image.png"));
			return this;
	 }

	 public int getImageNum(ImageNum num) {
			return num.ordinal();
	 }

	 public void loadImages() {
			console.info("[ReferenceImageOverlay] Loading images...");
			for (int i = 0; i < this.imageUrls.length; i++) {
				 if (this.imageUrls[i] != null && !this.imageUrls[i].isEmpty()) {
						this.imagesLoaded[i] = ImageLoader.loadTextureFromURL(this.imageUrls[i], "image" + (i + 1));
				 } else {
						this.imagesLoaded[i] = class_2960.method_60655("reference_image_overlay", "textures/gui/null_image.png");
				 }
			}
			console.info("[ReferenceImageOverlay] Images loaded!");
	 }

}