package com.github.wyzzard225.reference_image_overlay.client;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

import static com.github.wyzzard225.reference_image_overlay.client.Settings.ImageNum.*;

public class CustomConfigScreen {
	 public static class_437 create(class_437 parent) {
			ConfigBuilder builder = ConfigBuilder.create()
							.setParentScreen(parent)
							.setTitle(class_2561.method_43470("Reference Image Overlay Settings"))
							.setSavingRunnable(ConfigManager::save);

			ConfigEntryBuilder entryBuilder = builder.entryBuilder();
			ConfigCategory visualSettings = builder.getOrCreateCategory(class_2561.method_43470("Image Settings"));

			//categories

			SubCategoryBuilder fileUploading = entryBuilder.startSubCategory(class_2561.method_43470("Image Source Settings"))
							.setExpanded(false);

			SubCategoryBuilder positionSettings1 = entryBuilder.startSubCategory(class_2561.method_43470("Image 1 Position Settings"))
							.setExpanded(false);

			SubCategoryBuilder positionSettings2 = entryBuilder.startSubCategory(class_2561.method_43470("Image 2 Position Settings"))
							.setExpanded(false);

			//settings

			fileUploading.add(entryBuilder.startEnumSelector(class_2561.method_43470("Image 1 Number"), Settings.ImageNum.class, Settings.INSTANCE.image1Num)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image1Num = newValue)
							.setTooltip(class_2561.method_43470("Which image url to display\nUseful for quickly switching between images"))
							.setDefaultValue(Settings.defaultSettings.image1Num)
							.setEnumNameProvider(value -> switch (value) {
								 case NONE -> class_2561.method_43470("Hidden");
								 case IMAGE_1 -> class_2561.method_43470("Image 1");
								 case IMAGE_2 -> class_2561.method_43470("Image 2");
								 case IMAGE_3 -> class_2561.method_43470("Image 3");
								 case IMAGE_4 -> class_2561.method_43470("Image 4");
								 case IMAGE_5 -> class_2561.method_43470("Image 5");
								 case IMAGE_6 -> class_2561.method_43470("Image 6");
								 case IMAGE_7 -> class_2561.method_43470("Image 7");
								 case IMAGE_8 -> class_2561.method_43470("Image 8");
								 case IMAGE_9 -> class_2561.method_43470("Image 9");
								 case IMAGE_10 -> class_2561.method_43470("Image 10");
								 default -> class_2561.method_43470("Unknown Value");
							})
							.build());

			fileUploading.add(entryBuilder.startEnumSelector(class_2561.method_43470("Image 2 Number"), Settings.ImageNum.class, Settings.INSTANCE.image2Num)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image2Num = newValue)
							.setTooltip(class_2561.method_43470("Which image url to display\nUseful for quickly switching between images"))
							.setDefaultValue(Settings.defaultSettings.image2Num)
							.setEnumNameProvider(value -> switch (value) {
								 case NONE -> class_2561.method_43470("Hidden");
								 case IMAGE_1 -> class_2561.method_43470("Image 1");
								 case IMAGE_2 -> class_2561.method_43470("Image 2");
								 case IMAGE_3 -> class_2561.method_43470("Image 3");
								 case IMAGE_4 -> class_2561.method_43470("Image 4");
								 case IMAGE_5 -> class_2561.method_43470("Image 5");
								 case IMAGE_6 -> class_2561.method_43470("Image 6");
								 case IMAGE_7 -> class_2561.method_43470("Image 7");
								 case IMAGE_8 -> class_2561.method_43470("Image 8");
								 case IMAGE_9 -> class_2561.method_43470("Image 9");
								 case IMAGE_10 -> class_2561.method_43470("Image 10");
								 default -> class_2561.method_43470("Unknown Value");
							})
							.build());

			generateUrlInputs(Settings.INSTANCE.imageUrls.length, fileUploading, entryBuilder);

			int screenWidth = class_310.method_1551().method_22683().method_4480()/2;
			int screenHeight = class_310.method_1551().method_22683().method_4507()/2;

			positionSettings1.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 1 X Position"), Settings.INSTANCE.image1Pos.get("x"), 0, screenWidth)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image1Pos.put("x", newValue))
							.setDefaultValue(Settings.defaultSettings.image1Pos.get("x"))
							.setTooltip(class_2561.method_43470("The x position of Image 1"))
							.build());

			positionSettings1.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 1 Y Position"), Settings.INSTANCE.image1Pos.get("y"), 0, screenHeight)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image1Pos.put("y", newValue))
							.setDefaultValue(Settings.defaultSettings.image1Pos.get("y"))
							.setTooltip(class_2561.method_43470("The y position of Image 1"))
							.build());

			positionSettings1.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 1 Width"), Settings.INSTANCE.image1Pos.get("width"), 1, screenWidth)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image1Pos.put("width", newValue))
							.setDefaultValue(Settings.defaultSettings.image1Pos.get("width"))
							.setTooltip(class_2561.method_43470("The horizontal size of Image 1"))
							.build());

			positionSettings1.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 1 Height"), Settings.INSTANCE.image1Pos.get("height"), 0, screenHeight)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image1Pos.put("height", newValue))
							.setDefaultValue(Settings.defaultSettings.image1Pos.get("height"))
							.setTooltip(class_2561.method_43470("The vertical size of Image 1"))
							.build());


			positionSettings2.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 2 X Position"), Settings.INSTANCE.image2Pos.get("x"), 0, screenWidth)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image2Pos.put("x", newValue))
							.setDefaultValue(Settings.defaultSettings.image2Pos.get("x"))
							.setTooltip(class_2561.method_43470("The x position of Image 2"))
							.build());

			positionSettings2.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 2 Y Position"), Settings.INSTANCE.image2Pos.get("y"), 0, screenHeight)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image2Pos.put("y", newValue))
							.setDefaultValue(Settings.defaultSettings.image2Pos.get("y"))
							.setTooltip(class_2561.method_43470("The y position of Image 2"))
							.build());

			positionSettings2.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 2 Width"), Settings.INSTANCE.image2Pos.get("width"), 2, screenWidth)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image2Pos.put("width", newValue))
							.setDefaultValue(Settings.defaultSettings.image2Pos.get("width"))
							.setTooltip(class_2561.method_43470("The horizontal size of Image 2"))
							.build());

			positionSettings2.add(entryBuilder.startIntSlider(class_2561.method_43470("Image 2 Height"), Settings.INSTANCE.image2Pos.get("height"), 0, screenHeight)
							.setSaveConsumer(newValue -> Settings.INSTANCE.image2Pos.put("height", newValue))
							.setDefaultValue(Settings.defaultSettings.image2Pos.get("height"))
							.setTooltip(class_2561.method_43470("The vertical size of Image 2"))
							.build());


			//registering settings

			visualSettings.addEntry(fileUploading.build());
			visualSettings.addEntry(positionSettings1.build());
			visualSettings.addEntry(positionSettings2.build());
			return builder.build();
	 }

	 private static void generateUrlInputs(int num, SubCategoryBuilder fileUploading, ConfigEntryBuilder entryBuilder) {
			for (int i = 0; i < num; i++) {
				 final int index = i;
				 fileUploading.add(entryBuilder.startStrField(class_2561.method_43470("Image " + (i + 1) + " URL"), Settings.INSTANCE.imageUrls[i])
								 .setSaveConsumer(newValue -> Settings.INSTANCE.imageUrls[index] = newValue)
								 .setDefaultValue(Settings.defaultSettings.imageUrls[i])
								 .setTooltip(class_2561.method_43470("Enter the URL of the image you want to use for Image " + (i + 1) + "\nLeave empty to render nothing\n\nMust be a .png file"))
								 .build());
			}
	 }
}