package com.github.wyzzard225.reference_image_overlay.client;


import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

import static com.github.wyzzard225.reference_image_overlay.client.Reference_image_overlayClient.console;

public class ImageLoader {
	 public static class_2960 loadTextureFromURL(String urlString, String textureName) {
			try {
				 if (!urlString.contains("http")) {
						//not a link so return null
						return class_2960.method_60655("reference_image_overlay", "textures/gui/null_image.png");
				 }

				 //download the image from url string
				 URL url = new URI(urlString).toURL();
				 InputStream stream = url.openStream();
				 class_1011 image = class_1011.method_4309(stream);

				 //fix texture name in case of invalid characters (must be lowercase without spaces)
				 Supplier<String> fileName = () -> textureName.toLowerCase().replaceAll("[^a-z0-9/._-]", "_");

				 //convert image to texture
				 class_1043 texture = new class_1043(fileName, image);

					//create an identifier for the texture
				 class_2960 id = class_2960.method_60655("dynamic", textureName);


				 //register the texture
				 class_310.method_1551().method_1531().method_4616(id, texture);
				 return id;
			} catch (Exception e) {
				 console.error("[ReferenceImageOverlay] Failed loading image: "+textureName+ Arrays.toString(e.getStackTrace()));
				 return class_2960.method_60655("reference_image_overlay", "textures/gui/null_image.png");
			}
	 }
}
