package com.github.wyzzard225.reference_image_overlay.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

//Adjust IMAGE, imgW/imgH, and x/y to change the texture or its position.
public class Reference_image_overlayClient implements ClientModInitializer {
	 public static final Logger console = LogManager.getLogger("ReferenceImageOverlay");
	 public static final String MODID = "reference_image_overlay";
	 //image path: resources/assets/reference_image_overlay/textures/gui/null_image.png

	 @Override
	 public void onInitializeClient() {
			console.info("ReferenceImageOverlay is now loaded!");
			console.info("[ReferenceImageOverlay] Loading config...");
			if (ConfigManager.load()) {
				 console.info("[ReferenceImageOverlay] Settings loaded!");
			} else {
				 Settings.INSTANCE.resetSettings();
				 console.warn("[ReferenceImageOverlay] No config file found, default settings loaded!");
			}
			//render it before chat
			HudElementRegistry.attachElementBefore(
							VanillaHudElements.CHAT,
							class_2960.method_60655(MODID, "image_overlay"),
							this::render
			);

			ClientLifecycleEvents.CLIENT_STARTED.register(client -> Settings.INSTANCE.loadImages());
	 }


	 private void render(class_332 context, class_9779 tickCounter) {
			int imageNum1 = Settings.INSTANCE.getImageNum(Settings.INSTANCE.image1Num);
			int imageNum2 = Settings.INSTANCE.getImageNum(Settings.INSTANCE.image2Num);
			if (Settings.INSTANCE.image1Num != Settings.ImageNum.NONE && imageNum1 != 0 && Settings.INSTANCE.imageUrls[imageNum1-1] != null) {
				 //size
				 final int imgW = Settings.INSTANCE.image1Pos.get("width");
				 final int imgH = Settings.INSTANCE.image1Pos.get("height");

				 //position
				 final int x = Settings.INSTANCE.image1Pos.get("x");
				 final int y = Settings.INSTANCE.image1Pos.get("y");

				 class_2960 IMAGE_1 = Settings.INSTANCE.imagesLoaded[imageNum1-1];

				 //uv coordinates are 0, 0
				 context.method_25290(class_10799.field_56883, IMAGE_1, x, y, 0f, 0f, imgW, imgH, imgW, imgH);
			}
			if (Settings.INSTANCE.image2Num != Settings.ImageNum.NONE && imageNum2 != 0 && Settings.INSTANCE.imageUrls[imageNum2-1] != null) {
				 //size
				 final int imgW = Settings.INSTANCE.image2Pos.get("width");
				 final int imgH = Settings.INSTANCE.image2Pos.get("height");

				 //position
				 final int x = Settings.INSTANCE.image2Pos.get("x");
				 final int y = Settings.INSTANCE.image2Pos.get("y");

				 class_2960 IMAGE_2 = Settings.INSTANCE.imagesLoaded[imageNum2-1];

				 //uv coordinates are 0, 0
				 context.method_25290(class_10799.field_56883, IMAGE_2, x, y, 0f, 0f, imgW, imgH, imgW, imgH);
			}
	 }
}
