/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.render;

import com.mojang.blaze3d.textures.GpuTextureView;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5611;
import net.minecraft.class_777;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockEntityVertexConsumer
implements class_4588 {
    private Model model = new Model();
    private Mesh mesh;
    private int vertCount = 0;
    private Vector3f tmpPos = new Vector3f();
    private Vector3f tmpNormal = new Vector3f();
    private Vector3f tmp1 = new Vector3f();
    private Vector3f tmp2 = new Vector3f();

    public BlockEntityVertexConsumer(GpuTextureView gpuTexture) {
        this.mesh = this.model.mesh = new Mesh();
        this.model.textureID = gpuTexture;
    }

    public void validateModel() {
        int indicesFaceCount;
        int faceCount = this.mesh.positions.size() / 4;
        if (faceCount != (indicesFaceCount = this.mesh.indices.size() / 6)) {
            int i;
            this.mesh.indices.clear();
            int index = 0;
            for (i = 0; i < faceCount; ++i) {
                this.mesh.indices.add(index);
                this.mesh.indices.add(index + 1);
                this.mesh.indices.add(index + 2);
                this.mesh.indices.add(index);
                this.mesh.indices.add(index + 2);
                this.mesh.indices.add(index + 3);
                index += 4;
            }
            if (this.mesh.positions.size() != this.mesh.normals.size()) {
                for (i = this.mesh.normals.size(); i < this.mesh.positions.size(); ++i) {
                    Vector3f tmp1;
                    int face = i / 4;
                    Vector3f pos0 = this.mesh.positions.get(face * 4 + 1);
                    Vector3f pos1 = this.mesh.positions.get(face * 4 + 2);
                    Vector3f pos2 = this.mesh.positions.get(face * 4 + 3);
                    Vector3f tmp0 = pos1.sub((Vector3fc)pos0, this.tmp1);
                    Vector3f normal = tmp0.cross((Vector3fc)(tmp1 = pos2.sub((Vector3fc)pos0, this.tmp2)));
                    float length = normal.lengthSquared();
                    if ((double)length != 0.0) {
                        normal.mul(1.0f / length);
                    } else {
                        normal.set(0.0, 1.0, 0.0);
                    }
                    this.mesh.normals.add(normal);
                }
            }
        }
    }

    public class_4588 method_22912(float x, float y, float z) {
        this.mesh.positions.add(new Vector3f(x, y, z));
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        this.mesh.addColor(red, green, blue, alpha);
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        this.mesh.uvs.add(new Vector2f(u, v));
        return this;
    }

    public class_4588 method_60796(int u, int v) {
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        this.mesh.normals.add(new Vector3f(x, y, z));
        return this;
    }

    public class_4588 method_22918(Matrix4fc matrix, float x, float y, float z) {
        this.tmpPos.set(x, y, z);
        matrix.transformPosition(this.tmpPos);
        this.mesh.positions.add(new Vector3f(this.tmpPos.x(), this.tmpPos.y(), this.tmpPos.z()));
        return this;
    }

    public class_4588 method_60831(class_4587.class_4665 pose, float x, float y, float z) {
        this.tmpNormal.set(x, y, z);
        pose.method_56820(x, y, z, this.tmpNormal);
        this.mesh.normals.add(new Vector3f(this.tmpNormal.x(), this.tmpNormal.y(), this.tmpNormal.z()));
        return this;
    }

    public void method_22920(class_4587.class_4665 pose, class_777 quad, float[] brightness, float red, float green, float blue, float alpha, int[] lights, int overlay) {
        Vector3fc direction = quad.comp_3723().method_68072();
        Matrix4f matrix4f = pose.method_23761();
        pose.method_56821(direction, this.tmpNormal);
        for (int l = 0; l < 4; ++l) {
            Vector3fc quadPos = quad.method_76648(l);
            long packedUv = quad.method_76649(l);
            float b = brightness[l];
            matrix4f.transformPosition(quadPos, this.tmpPos);
            float u = class_5611.method_76641((long)packedUv);
            float v = class_5611.method_76642((long)packedUv);
            this.mesh.positions.add(new Vector3f(this.tmpPos.x(), this.tmpPos.y(), this.tmpPos.z()));
            this.mesh.addColor(b * red, b * green, b * blue);
            this.mesh.normals.add(new Vector3f(this.tmpNormal.x(), this.tmpNormal.y(), this.tmpNormal.z()));
            this.mesh.uvs.add(new Vector2f(u, v));
        }
        int index = this.mesh.positions.size() - 4;
        this.mesh.indices.add(index);
        this.mesh.indices.add(index + 1);
        this.mesh.indices.add(index + 2);
        this.mesh.indices.add(index);
        this.mesh.indices.add(index + 2);
        this.mesh.indices.add(index + 3);
        PhysicsMod.getCurrentInstance().itemStackEntity.shade = quad.comp_3725();
    }

    public void method_23919(float x, float y, float z, int color, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
        ++this.vertCount;
        this.mesh.positions.add(new Vector3f(x, y, z));
        this.mesh.addColor((float)class_9848.method_61327((int)color) / 255.0f, (float)class_9848.method_61329((int)color) / 255.0f, (float)class_9848.method_61331((int)color) / 255.0f, (float)class_9848.method_61320((int)color) / 255.0f);
        this.mesh.normals.add(new Vector3f(normalX, normalY, normalZ));
        this.mesh.uvs.add(new Vector2f(u, v));
        if (this.vertCount == 4) {
            this.vertCount = 0;
            int index = this.mesh.positions.size() - 4;
            this.mesh.indices.add(index);
            this.mesh.indices.add(index + 1);
            this.mesh.indices.add(index + 2);
            this.mesh.indices.add(index);
            this.mesh.indices.add(index + 2);
            this.mesh.indices.add(index + 3);
        }
    }

    public class_4588 method_22915(float red, float green, float blue, float alpha) {
        this.mesh.addColor(red, green, blue, alpha);
        return this;
    }

    public class_4588 method_60803(int uv) {
        return this;
    }

    public class_4588 method_22922(int uv) {
        return this;
    }

    public class_4588 method_39415(int color) {
        this.mesh.addColor((float)class_9848.method_61327((int)color) / 255.0f, (float)class_9848.method_61329((int)color) / 255.0f, (float)class_9848.method_61331((int)color) / 255.0f, (float)class_9848.method_61320((int)color) / 255.0f);
        return this;
    }

    public class_4588 method_75298(float f) {
        return this;
    }

    public Model getModel() {
        return this.model;
    }
}

