/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsSubScreen;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class LiquidSettingsScreen
extends LegacyOptionsSubScreen {
    private LegacyOptionsList list;
    private static final CycleOption<Boolean> PHYSICS_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.liquidphysics", gameOptions -> ConfigClient.liquidPhysics, (gameOptions, option, value) -> {
        ConfigClient.liquidPhysics = value;
        ConfigClient.save();
        if (!ConfigClient.liquidPhysics) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
                for (Liquid liquid : liquids) {
                    mod.getPhysicsWorld().removeLiquid(liquid);
                }
            }
        }
    });
    private final CycleOption<Boolean> PHYSICS_CUDA_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.cudaliquids", gameOptions -> ConfigClient.cudaLiquids, (gameOptions, option, value) -> {
        if (((CycleOption)option).active) {
            ConfigClient.cudaLiquids = value;
            ConfigClient.save();
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().destroy();
            }
            PhysicsMod.getInstances().clear();
            StarterClient.createPhysicsCooking(ConfigClient.useCuda());
            this.list.method_25396().clear();
            class_310.method_1551().method_1507((class_437)new LiquidSettingsScreen(this.lastScreen, this.options));
        }
    }).setTooltip(minecraft -> graphicsStatus -> {
        if (!StarterClient.cudaAvailable) {
            return class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.error");
        }
        return class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.info");
    });
    private static final ProgressOption PHYSICS_LIQUID_PARTICLE_SIZE = new ProgressOption("physicsmod.menu.liquid.size", 0.05, 0.5, 0.01f, gameOptions -> ConfigClient.liquidParticleSize, (gameOptions, value) -> {
        ConfigClient.liquidParticleSize = value.floatValue();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().destroy();
        }
        PhysicsMod.getInstances().clear();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.size", String.format("%.2f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.size.info"));
    private static final ProgressOption PHYSICS_LIQUID_AMOUNT = new ProgressOption("physicsmod.menu.liquid.amount", 1.0, 64.0, 1.0f, gameOptions -> ConfigClient.liquidAmount, (gameOptions, value) -> {
        ConfigClient.liquidAmount = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.amount", Integer.toString((int)option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIQUID_MAX_PARTICLES = new ProgressOption("physicsmod.menu.liquid.maxpersource", 1.0, 200000.0, 1.0f, gameOptions -> ConfigClient.liquidMaxParticles, (gameOptions, value) -> {
        ConfigClient.liquidMaxParticles = Math.max(value.intValue(), 1);
        ConfigClient.save();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
            for (Liquid liquid : liquids) {
                mod.getPhysicsWorld().removeLiquid(liquid);
            }
        }
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.maxpersource", Integer.toString((int)option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_CUDA_LIQUID_PARTICLE_SIZE = new ProgressOption("physicsmod.menu.liquid.size", 0.05, 0.5, 0.01f, gameOptions -> ConfigClient.cudaLiquidsParticleSize, (gameOptions, value) -> {
        ConfigClient.cudaLiquidsParticleSize = value.floatValue();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().destroy();
        }
        PhysicsMod.getInstances().clear();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.size", String.format("%.2f", option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.size.info"));
    private static final ProgressOption PHYSICS_CUDA_LIQUID_AMOUNT = new ProgressOption("physicsmod.menu.liquid.amount", 1.0, 64.0, 1.0f, gameOptions -> ConfigClient.liquidCudaAmount, (gameOptions, value) -> {
        ConfigClient.liquidCudaAmount = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.amount", Integer.toString((int)option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_CUDA_LIQUID_MAX_PARTICLES = new ProgressOption("physicsmod.menu.liquid.maxpersource", 1.0, 200000.0, 1.0f, gameOptions -> ConfigClient.liquidCudaMaxParticles, (gameOptions, value) -> {
        ConfigClient.liquidCudaMaxParticles = Math.max(value.intValue(), 1);
        ConfigClient.save();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
            for (Liquid liquid : liquids) {
                mod.getPhysicsWorld().removeLiquid(liquid);
            }
        }
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.maxpersource", Integer.toString((int)option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_CUDA_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquidsCuda, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquidsCuda = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_CUDA_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquidsCuda, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquidsCuda = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final int MAX_INFO_WIDTH = 300;
    private List<class_5481> info;

    public LiquidSettingsScreen(class_437 parent, class_315 options) {
        super(parent, options, (class_2561)class_2561.method_43471((String)"physicsmod.menu.liquid.title"));
        this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.liquid.warning"), 300);
    }

    protected void method_25426() {
        this.list = new LegacyOptionsList(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25){

            @Override
            protected void renderDecorations(class_332 guiGraphics, int mouseX, int mouseY) {
                int yOffset = 137;
                if (ConfigClient.cudaLiquids()) {
                    yOffset = 137;
                }
                super.renderDecorations(guiGraphics, mouseX, mouseY);
            }
        };
        this.field_22786.add(this.list);
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 - 80, this.field_22790 - 27, 75, 20, (class_2561)class_2561.method_43471((String)"physicsmod.gui.pro"), button -> class_156.method_668().method_670("https://minecraftphysicsmod.com/pro")));
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 + 5, this.field_22790 - 27, 75, 20, class_5244.field_24334, button -> this.field_22787.method_1507(this.lastScreen)));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.list.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    @Override
    public void method_25419() {
        ConfigClient.save();
        super.method_25419();
    }

    private /* synthetic */ void lambda$init$44(class_4185 button) {
        PopupWidget.create(class_2477.method_10517().method_48307("physicsmod.menu.liquid.reset"), this, widget -> this.method_37063((class_364)widget), widget -> this.method_37066((class_364)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetLiquidSettings();
                for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                    mod.getPhysicsWorld().destroy();
                }
                PhysicsMod.getInstances().clear();
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new LiquidSettingsScreen(this.lastScreen, this.options));
            } else {
                this.list.method_25396().clear();
                this.field_22787.method_1507((class_437)new LiquidSettingsScreen(this.lastScreen, this.options));
            }
        });
    }

    private /* synthetic */ void lambda$init$40(class_4185 button) {
        this.method_25419();
        this.field_22787.method_1507(this.lastScreen);
    }
}

