/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Box;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.CurveType;
import net.diebuddies.physics.animation.ParticleSpawn;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.animation.ParticleExtension;
import net.diebuddies.physics.settings.gui.GuiPhysicsCustomRenderState;
import net.diebuddies.physics.settings.gui.GuiRenderable;
import net.diebuddies.physics.settings.ux.Animatable;
import net.minecraft.class_1059;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11256;
import net.minecraft.class_11944;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_703;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleDisplayScreen
extends class_437 {
    public static final class_2960 STONE_TEXTURE = class_2960.method_60656((String)"textures/block/stone.png");
    public class_437 parent;
    private double xPosition = 70.0;
    private double animationStart;
    private boolean createdParticles;
    public Animation animation;
    private List<class_703> particles;
    private class_4184 camera = new class_4184();
    private long lastTick = System.currentTimeMillis();

    protected ParticleDisplayScreen(class_437 parent, class_2561 component) {
        super(component);
        this.parent = parent;
        this.particles = new ObjectArrayList();
        this.animation = new Animation("default", CurveType.Linear, 0.5f);
    }

    protected void method_25426() {
        super.method_25426();
        this.startAnimation();
        this.method_37063((class_364)((class_4185)((Animatable)ButtonSettings.builder((int)this.xPosition - 30, this.field_22790 - 57, 60, 20, (class_2561)class_2561.method_43471((String)"physicsmod.menu.animation.replay"), button -> this.startAnimation()))));
    }

    public void startAnimation() {
        this.particles.clear();
        this.animationStart = (double)this.animation.speed + 0.5;
        this.createdParticles = false;
    }

    private void createParticles() {
        if (this.createdParticles) {
            return;
        }
        this.createdParticles = true;
        this.particles.clear();
        for (ParticleSpawn spawn : this.animation.particleSpawns) {
            class_2394 particleOptions = spawn.particle;
            if (particleOptions == null || !((double)Math.random() < spawn.spawnChance)) continue;
            for (int i = 0; i < spawn.amount; ++i) {
                double halfSpread = spawn.spread * 0.5;
                double px = (double)Math.random() * spawn.spread - halfSpread;
                double py = (double)Math.random() * spawn.spread - halfSpread;
                double pz = (double)Math.random() * spawn.spread - halfSpread;
                try {
                    class_703 particle = class_310.method_1551().field_1713.method_3056(particleOptions, px, py, pz, spawn.vx, spawn.vy, spawn.vz);
                    ((ParticleExtension)particle).setPhysics(false);
                    ((ParticleExtension)particle).setFakeLight(true);
                    this.particles.add(particle);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (spawn.sound == null) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)spawn.sound, (float)1.0f));
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        this.renderAnimation(guiGraphics, delta);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25393() {
        super.method_25393();
        this.lastTick = System.currentTimeMillis();
        Iterator<class_703> it = this.particles.iterator();
        while (it.hasNext()) {
            class_703 particle = it.next();
            if (!particle.method_3086()) continue;
            try {
                particle.method_3070();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (particle.method_3086()) continue;
            it.remove();
        }
    }

    private void renderAnimation(class_332 guiGraphics, final float delta) {
        GuiRenderable renderable = new GuiRenderable(){

            @Override
            public void render() {
                float scale = 30.0f;
                Matrix4fStack matrices = RenderSystem.getModelViewStack();
                float realDelta = java.lang.Math.min(1.0f, (float)(System.currentTimeMillis() - ParticleDisplayScreen.this.lastTick) / 50.0f);
                matrices.pushMatrix();
                matrices.scale((float)class_310.method_1551().method_22683().method_4495());
                matrices.translate((float)ParticleDisplayScreen.this.xPosition, (float)ParticleDisplayScreen.this.field_22790 / 2.0f, 100.0f);
                matrices.scale(scale, -scale, scale);
                matrices.pushMatrix();
                matrices.rotate((Quaternionfc)new Quaternionf().rotationXYZ((float)java.lang.Math.toRadians(25.0), (float)java.lang.Math.toRadians(-25.0), 0.0f));
                class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
                int brightness = 0xF00000;
                ParticleDisplayScreen.this.animationStart -= (double)delta * 0.05;
                float despawnScale = ParticleDisplayScreen.this.animation.getCurve().get((float)(ParticleDisplayScreen.this.animationStart / (double)ParticleDisplayScreen.this.animation.speed));
                if (ParticleDisplayScreen.this.animationStart > (double)ParticleDisplayScreen.this.animation.speed) {
                    despawnScale = 1.0f;
                } else if (ParticleDisplayScreen.this.animationStart <= 0.0) {
                    despawnScale = 0.0f;
                }
                float alpha = 1.0f;
                if (ParticleDisplayScreen.this.animation.despawnType == AnimationType.Vanish) {
                    alpha = java.lang.Math.min(1.0f, despawnScale);
                    despawnScale = 1.0f;
                } else if (ParticleDisplayScreen.this.animation.despawnType == AnimationType.Shrink_and_Vanish) {
                    alpha = java.lang.Math.min(1.0f, despawnScale);
                }
                class_1921 renderType = class_12249.method_76000((class_2960)STONE_TEXTURE);
                class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
                class_4588 vertexConsumer = bufferSource.method_73477(renderType);
                int[] indices = Box.INDICES;
                float[] positions = Box.POSITIONS;
                float[] normals = Box.NORMALS;
                float[] uvs = Box.UVS;
                for (int i = 0; i < indices.length; ++i) {
                    int index = indices[i];
                    float x = positions[index * 3] * 0.5f * despawnScale;
                    float y = positions[index * 3 + 1] * 0.5f * despawnScale;
                    float z = positions[index * 3 + 2] * 0.5f * despawnScale;
                    float nx = normals[index * 3];
                    float ny = normals[index * 3 + 1];
                    float nz = normals[index * 3 + 2];
                    float uvx = uvs[index * 2];
                    float uvy = uvs[index * 2 + 1];
                    vertexConsumer.method_22912(x, y, z).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(uvx, uvy).method_22922(class_4608.field_21444).method_60803(brightness).method_22914(nx, ny, nz);
                }
                bufferSource.method_22993();
                if (ParticleDisplayScreen.this.animationStart <= 0.0) {
                    ParticleDisplayScreen.this.createParticles();
                }
                matrices.popMatrix();
                renderType = class_12249.method_76000((class_2960)class_1059.field_17898);
                vertexConsumer = bufferSource.method_73477(renderType);
                CustomQuadParticleRenderState particleState = new CustomQuadParticleRenderState(ParticleDisplayScreen.this, vertexConsumer);
                for (class_703 particle : ParticleDisplayScreen.this.particles) {
                    if (!particle.method_3086() || !(particle instanceof class_3940)) continue;
                    class_3940 quadParticle = (class_3940)particle;
                    quadParticle.method_3074((class_11944)particleState, ParticleDisplayScreen.this.camera, realDelta);
                }
                bufferSource.method_22993();
                matrices.popMatrix();
            }
        };
        guiGraphics.field_59826.method_70922((class_11256)new GuiPhysicsCustomRenderState(renderable, 0, 0, class_310.method_1551().method_22683().method_4489(), class_310.method_1551().method_22683().method_4506(), 1.0f, null));
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    private class CustomQuadParticleRenderState
    extends class_11944 {
        private class_4588 consumer;

        public CustomQuadParticleRenderState(ParticleDisplayScreen particleDisplayScreen, class_4588 consumer) {
            this.consumer = consumer;
        }

        public void method_74323(class_3940.class_11941 layer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, int r, int s) {
            this.method_74321(this.consumer, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
        }

        protected void method_74321(class_4588 vertexConsumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, int r, int s) {
            Quaternionf quaternionf = new Quaternionf(i, j, k, l);
            this.renderVertex(vertexConsumer, quaternionf, f, g, h, 1.0f, -1.0f, m, o, q, r, s);
            this.renderVertex(vertexConsumer, quaternionf, f, g, h, 1.0f, 1.0f, m, o, p, r, s);
            this.renderVertex(vertexConsumer, quaternionf, f, g, h, -1.0f, 1.0f, m, n, p, r, s);
            this.renderVertex(vertexConsumer, quaternionf, f, g, h, -1.0f, -1.0f, m, n, q, r, s);
        }

        private void renderVertex(class_4588 vertexConsumer, Quaternionf quaternionf, float f, float g, float h, float i, float j, float k, float l, float m, int n, int o) {
            Vector3f vector3f = new Vector3f(i, j, 0.0f).rotate((Quaternionfc)quaternionf).mul(k).add(f, g, h);
            vertexConsumer.method_22912(vector3f.x(), vector3f.y(), vector3f.z()).method_39415(n).method_22913(l, m).method_22922(class_4608.field_21444).method_60803(o).method_22914(0.0f, -1.0f, 0.0f);
        }
    }
}

