/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_10017;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class LeashConstraint
implements VerletConstraint {
    private Vector3d leashOriginAsync = new Vector3d();
    private Vector3d leashTargetAsync = new Vector3d();
    private Vector3d leashOrigin = new Vector3d();
    private Vector3d leashTarget = new Vector3d();

    public LeashConstraint(VerletSimulation simulation, class_10017.class_10018 leashState) {
        int i;
        this.leashOrigin = new Vector3d(leashState.field_53340.field_1352, leashState.field_53340.field_1351, leashState.field_53340.field_1350);
        this.leashTarget = new Vector3d(leashState.field_53341.field_1352, leashState.field_53341.field_1351, leashState.field_53341.field_1350);
        int pointCount = 20;
        double totalLength = ConfigClient.leashLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp((double)this.leashOrigin.x, (double)this.leashTarget.x, (double)perc), Math.lerp((double)this.leashOrigin.y, (double)this.leashTarget.y, (double)perc), Math.lerp((double)this.leashOrigin.z, (double)this.leashTarget.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            float colMod = i % 2 == 0 ? 0.7f : 1.0f;
            float r = 0.5f * colMod;
            float g = 0.4f * colMod;
            float b = 0.3f * colMod;
            point.rgba.set(r, g, b, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    public void setLeashState(class_10017.class_10018 leashState) {
        this.leashOrigin.set(leashState.field_53340.field_1352, leashState.field_53340.field_1351, leashState.field_53340.field_1350);
        this.leashTarget.set(leashState.field_53341.field_1352, leashState.field_53341.field_1351, leashState.field_53341.field_1350);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        this.leashOriginAsync.set((Vector3dc)this.leashOrigin);
        this.leashTargetAsync.set((Vector3dc)this.leashTarget);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint originPoint = simulation.getPoints().get(0);
        VerletPoint targetPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        originPoint.position.set((Vector3dc)this.leashOriginAsync).sub((Vector3dc)simulation.getOffset());
        targetPoint.position.set((Vector3dc)this.leashTargetAsync).sub((Vector3dc)simulation.getOffset());
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set((Vector3dc)this.leashOrigin).sub((Vector3dc)simulation.getOffset());
        armPoint.bufferPrevPosition.set((Vector3dc)armPoint.bufferPosition);
        hookPoint.bufferPosition.set((Vector3dc)this.leashTarget).sub((Vector3dc)simulation.getOffset());
        hookPoint.bufferPrevPosition.set((Vector3dc)hookPoint.bufferPosition);
    }
}

