/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.mixins.ocean.MixinLightTextureAccessor;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.FBO;
import net.diebuddies.opengl.Pack;
import net.diebuddies.opengl.SaveTexture;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.GaussianDepthBlurEffect;
import net.diebuddies.render.shader.LiquidShader;
import net.diebuddies.render.shader.PhysicsShaderExtension;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.class_10799;
import net.minecraft.class_10859;
import net.minecraft.class_10866;
import net.minecraft.class_10867;
import net.minecraft.class_10868;
import net.minecraft.class_11282;
import net.minecraft.class_11515;
import net.minecraft.class_1163;
import net.minecraft.class_12134;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;

public class LiquidDeferredRenderer {
    private MainRenderer mainRenderer;
    private static FBO depthFBO;
    private static LiquidShader liquidShader;
    private static VAO liquidVAO;
    private static VAO emptyVAO;
    private static GpuTexture liquidDepthCopy;
    private static Texture depth;
    private static Texture light;
    private static GaussianDepthBlurEffect blurEffect;
    private static byte[] liquidlight;
    private static float[] liquidpos;
    private static float[] liquidposnew;
    private int liquidCount;
    private int depthActiveTexture;
    private int lightmapActiveTexture;
    private int lightcoordsActiveTexture;
    private Vector4f waterBounds = new Vector4f();
    private Vector2f waterMidCoord = new Vector2f();
    private GpuTextureView waterID;
    private boolean needsInstanceUpdate = false;
    private Vector3d offsetCamera = new Vector3d(0.0, 0.0, 0.0);
    private Matrix4f tmpMatrix = new Matrix4f();

    public LiquidDeferredRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(PhysicsWorld physics, class_11515 sectionLayer, class_638 level, Matrix4fStack matrixStackIn, class_243 cameraPos) {
    }

    private void renderInstancedLiquidSpheres(PhysicsWorld physics, class_638 level, Matrix4fStack modelView, class_243 cameraPos) {
        class_11282.class_11283 transform = MainRenderer.createTransformUniform((Matrix4f)modelView);
        GpuBufferSlice[] gpuBuffer = RenderSystem.getDynamicUniforms().method_71107(new class_11282.class_11283[]{transform});
        RenderPass renderPass = this.bindLiquidsShader();
        class_5944 program = ((class_10866)renderPass).field_57868.comp_3802();
        class_284.class_11272 dynamicTransforms = (class_284.class_11272)program.method_34582("DynamicTransforms");
        this.initRenderingStates(level, renderPass, true);
        this.setupLiquidsRendering(physics, level, renderPass, this.waterID, cameraPos);
        GlStateManager._enableCull();
        if (dynamicTransforms != null) {
            GpuBufferSlice slice = gpuBuffer[0];
            GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.comp_4150(), (int)((class_10859)slice.buffer()).field_57842, (long)slice.offset(), (long)slice.length());
        }
        if (StarterClient.iris) {
            Iris.setNormalMatrix(renderPass, (Matrix4fc)modelView);
        }
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.field_1352 - offset.x, cameraPos.field_1351 - offset.y, cameraPos.field_1350 - offset.z);
        PhysicsShaderExtension shaderExtension = (PhysicsShaderExtension)program;
        int cameraLocation = shaderExtension.physicsmod$getUniformLocation("physics_liquidCameraPos");
        int renderPercentLocation = shaderExtension.physicsmod$getUniformLocation("physics_renderPercent");
        if (cameraLocation != -1) {
            GL32C.glUniform3f((int)cameraLocation, (float)((float)this.offsetCamera.x), (float)((float)this.offsetCamera.y), (float)((float)this.offsetCamera.z));
        }
        if (renderPercentLocation != -1) {
            GL32C.glUniform1f((int)renderPercentLocation, (float)((float)physics.getRenderPercent()));
        }
        liquidVAO.renderInstanced(this.liquidCount);
        renderPass.close();
    }

    private void renderLiquidDataIntoTexture(PhysicsWorld physics, class_11515 sectionLayer, class_638 level, class_243 cameraPos) {
        class_276 renderTarget = class_310.method_1551().method_1522();
        liquidDepthCopy = SaveTexture.copyFramebufferDepthTexture(liquidDepthCopy, renderTarget.method_30278());
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Liquid Deferred Data", sectionLayer.method_72020());
        this.mainRenderer.setupShader(renderPass);
        GpuTextureView renderTargetColor = renderTarget.method_71639();
        GpuTexture before = liquidDepthCopy;
        if (depthFBO == null || before != liquidDepthCopy) {
            if (depthFBO != null) {
                depthFBO.destroy(false);
                blurEffect.destroy();
                depth.destroy();
                light.destroy();
            }
            blurEffect = new GaussianDepthBlurEffect();
            depthFBO = new FBO();
            depth = Texture.createTexture(renderTargetColor.getWidth(0), renderTargetColor.getHeight(0), 33326, 6403, 5126);
            light = Texture.createTexture(renderTargetColor.getWidth(0), renderTargetColor.getHeight(0), 33330, 36244, 5121);
            depthFBO.attachColorBuffer(depth);
            depthFBO.attachColorBuffer(light);
            depthFBO.attachDepthBuffer(liquidDepthCopy);
            depthFBO.checkError();
            blurEffect.setImage(depthFBO);
        }
        liquidShader.bind();
        depthFBO.bind();
        depthFBO.drawBuffers(0, 1);
        liquidVAO.bind();
        GL32C.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager._clear((int)16384);
        GlStateManager._disableBlend();
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.field_1352 - offset.x, cameraPos.field_1351 - offset.y, cameraPos.field_1350 - offset.z);
        LiquidShader shader = liquidShader;
        shader.bind();
        shader.uploadMatrix(shader.getUniformLocation("ModelViewMat"), RenderSystem.getModelViewMatrix());
        shader.uploadMatrix(shader.getUniformLocation("ProjMat"), this.mainRenderer.projectionMatrix);
        shader.setUniform3(shader.getUniformLocation("LiquidCameraPos"), (float)this.offsetCamera.x, (float)this.offsetCamera.y, (float)this.offsetCamera.z);
        double renderPercent = physics.getRenderPercent();
        shader.setUniform1(shader.getUniformLocation("RenderPercent"), (float)renderPercent);
        liquidVAO.renderInstanced(this.liquidCount);
        depthFBO.drawBuffers(0);
        blurEffect.render(this.mainRenderer.projectionMatrix, physics.fluidParticleSize * 6.0f, emptyVAO);
        renderPass.close();
        renderPass = this.bindLiquidsShader();
        this.initRenderingStates(level, renderPass, false);
        this.setupLiquidsRendering(physics, level, renderPass, this.waterID, cameraPos);
        emptyVAO.renderEmptyTriangle();
        renderPass.close();
    }

    private RenderPass bindLiquidsShader() {
        RenderPipeline renderPipeline = class_10799.field_56895;
        class_10867 customPipeline = null;
        if (StarterClient.iris && Iris.isExtending()) {
            if (Iris.isShadowPass()) {
                if (Iris.getLiquidShadowProgram() != null) {
                    customPipeline = new class_10867(renderPipeline, Iris.getLiquidShadowProgram());
                } else {
                    renderPipeline = class_10799.field_64225;
                }
            } else if (Iris.getLiquidProgram() != null) {
                customPipeline = new class_10867(renderPipeline, Iris.getLiquidProgram());
            } else {
                renderPipeline = class_10799.field_56895;
            }
        } else if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            renderPipeline = PhysicsShaders.PHYSICS_LIQUID_PIPELINE;
        }
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60025);
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Liquid Deferred", renderPipeline, customPipeline);
        class_10866 glRenderPass = (class_10866)renderPass;
        glRenderPass.field_57877.method_68351(glRenderPass, Collections.emptyList());
        return renderPass;
    }

    private void initRenderingStates(class_638 level, RenderPass renderPass, boolean shadowPass) {
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib3f((int)Data.NORMAL.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib3f((int)Data.NORMAL_SHADER.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        int color = class_1163.method_4961((class_1920)level, (class_2338)class_310.method_1551().field_1724.method_24515());
        GL32C.glVertexAttrib4f((int)Data.COLOR_SHADER.getAttribute(), (float)Pack.getRed(color), (float)Pack.getGreen(color), (float)Pack.getBlue(color), (float)1.0f);
        GL32C.glVertexAttribI2i((int)Data.LIGHT_SHADER.getAttribute(), (int)240, (int)240);
        GL32C.glVertexAttrib2f((int)Data.TEX_COORD_SHADER.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
        if (StarterClient.iris && Iris.isExtending()) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_TERRAIN_SHADER.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_TERRAIN_SHADER.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            mcEntityLocation = 5;
            GL32C.glVertexAttrib4f((int)mcEntityLocation, (float)Iris.getMaterialID(class_2246.field_10382.method_9564()), (float)1.0f, (float)-1.0f, (float)-1.0f);
        } else if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            mcEntityLocation = Optifine.isUsingShadersNoInternal() ? 11 : -1;
            if (mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)mcEntityLocation, (float)Optifine.getMaterialID(class_2246.field_10382.method_9564()), (float)Optifine.getRenderType(class_2246.field_10382.method_9564()), (float)-1.0f, (float)-1.0f);
            }
        }
        if (!shadowPass) {
            GlStateManager._activeTexture((int)(33984 + this.depthActiveTexture));
            GlStateManager._bindTexture((int)depth.getID());
            GL33C.glBindSampler((int)this.depthActiveTexture, (int)MainRenderer.TEXTURE_NEAREST_CLAMP_SAMPLER);
            GlStateManager._activeTexture((int)(33984 + this.lightcoordsActiveTexture));
            GlStateManager._bindTexture((int)light.getID());
            GL33C.glBindSampler((int)this.lightcoordsActiveTexture, (int)MainRenderer.TEXTURE_NEAREST_CLAMP_SAMPLER);
        }
        int lightmapTextureID = ((class_10868)((MixinLightTextureAccessor)class_310.method_1551().field_1773.method_22974()).getTarget()).method_68427();
        GlStateManager._activeTexture((int)(33984 + this.lightmapActiveTexture));
        GlStateManager._bindTexture((int)lightmapTextureID);
        GL33C.glBindSampler((int)this.lightmapActiveTexture, (int)((class_12134)MainRenderer.LINEAR_CLAMP_SAMPLER).method_75285());
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
    }

    private void setupLiquidsRendering(PhysicsWorld physics, class_638 level, RenderPass renderPass, GpuTextureView waterTexture, class_243 cameraPos) {
        FloatBuffer matrixBuffer;
        MemoryStack stack;
        class_5944 program = ((class_10866)renderPass).field_57868.comp_3802();
        Vector3d physicsOffset = physics.getOffset();
        PhysicsShaderExtension shaderExtension = (PhysicsShaderExtension)program;
        int depthLocation = shaderExtension.physicsmod$getUniformLocation("physics_depth");
        int lightmapLocation = shaderExtension.physicsmod$getUniformLocation("physics_lightmap");
        int lightcoordsLocation = shaderExtension.physicsmod$getUniformLocation("physics_lightcoords");
        int invProjLocation = shaderExtension.physicsmod$getUniformLocation("physics_invProjectionMatrix");
        int invViewLocation = shaderExtension.physicsmod$getUniformLocation("physics_invViewMatrix");
        int viewLocation = shaderExtension.physicsmod$getUniformLocation("physics_viewMatrix");
        int waterBoundsLocation = shaderExtension.physicsmod$getUniformLocation("physics_waterBounds");
        int cameraOffsetLocation = shaderExtension.physicsmod$getUniformLocation("physics_cameraOffset");
        if (depthLocation != -1) {
            GL32C.glUniform1i((int)depthLocation, (int)this.depthActiveTexture);
        }
        if (lightmapLocation != -1) {
            GL32C.glUniform1i((int)lightmapLocation, (int)this.lightmapActiveTexture);
        }
        if (lightcoordsLocation != -1) {
            GL32C.glUniform1i((int)lightcoordsLocation, (int)this.lightcoordsActiveTexture);
        }
        if (waterBoundsLocation != -1) {
            GL32C.glUniform4f((int)waterBoundsLocation, (float)this.waterBounds.x, (float)this.waterBounds.y, (float)this.waterBounds.z, (float)this.waterBounds.w);
        }
        if (cameraOffsetLocation != -1) {
            GL32C.glUniform3f((int)cameraOffsetLocation, (float)((float)(cameraPos.field_1352 - physicsOffset.x)), (float)((float)(cameraPos.field_1351 - physicsOffset.y)), (float)((float)(cameraPos.field_1350 - physicsOffset.z)));
        }
        if (invProjLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                this.mainRenderer.projectionMatrix.invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invProjLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (invViewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invViewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (viewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)viewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((class_10868)waterTexture.texture()).method_68427());
        GL33C.glBindSampler((int)0, (int)((class_12134)MainRenderer.NEAREST_SAMPLER).method_75285());
    }

    private VAO createLiquidVAO(Mesh mesh) {
        int size = mesh.indices.size();
        net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
        this.mainRenderer.checkArrays(size);
        for (int i = 0; i < size; ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f p = mesh.positions.get(index);
            Vector3f normal = mesh.normals.get(index);
            int cp = i * 3;
            this.mainRenderer.mpos[cp] = p.x;
            this.mainRenderer.mpos[cp + 1] = p.y;
            this.mainRenderer.mpos[cp + 2] = p.z;
            this.mainRenderer.mnormals[i] = Pack.normal(normal.x, normal.y, normal.z);
        }
        openglMesh.set(this.mainRenderer.mpos, Data.POSITION);
        openglMesh.set(this.mainRenderer.mnormals, Data.NORMAL);
        openglMesh.set(liquidlight, Data.LIQUID_LIGHT);
        openglMesh.set(liquidpos, Data.LIQUID_POS);
        openglMesh.set(liquidposnew, Data.LIQUID_POS_NEW);
        openglMesh.setSize(Data.POSITION, size * 3);
        openglMesh.setSize(Data.NORMAL, size);
        openglMesh.setSize(Data.INDEX, size);
        return openglMesh.constructVAO(Usage.DYNAMIC);
    }

    private void checkLiquidArrays(int neededSize) {
        int size;
        boolean changed = false;
        for (size = liquidpos.length; neededSize > size; size *= 2) {
            changed = true;
        }
        if (changed) {
            liquidlight = new byte[size];
            liquidpos = new float[size];
            liquidposnew = new float[size];
        }
    }

    public void updateLiquidInstances(PhysicsWorld physics, class_243 cameraPos) {
        Liquid liquid;
        int i;
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.field_1352 + offset.x, cameraPos.field_1351 + offset.y, cameraPos.field_1350 + offset.z);
        List<Liquid> liquids = physics.getLiquids();
        int size = 0;
        for (i = 0; i < liquids.size(); ++i) {
            liquid = liquids.get(i);
            size += liquid.particleCount();
        }
        this.checkLiquidArrays(size * 4);
        this.liquidCount = 0;
        for (i = 0; i < liquids.size(); ++i) {
            liquid = liquids.get(i);
            liquid.fillInstances(physics, liquidpos, liquidposnew, liquidlight, this.liquidCount);
            this.liquidCount += liquid.particleCount();
        }
        if (this.liquidCount == 0) {
            return;
        }
        liquidVAO.bind();
        liquidVAO.updateAttribute(Data.LIQUID_LIGHT, liquidlight, this.liquidCount * 4);
        liquidVAO.updateAttribute(Data.LIQUID_POS, liquidpos, this.liquidCount * 4);
        liquidVAO.updateAttribute(Data.LIQUID_POS_NEW, liquidposnew, this.liquidCount * 4);
    }

    public static void destroy() {
        if (depthFBO != null) {
            depthFBO.destroy(true);
        }
        if (liquidShader != null) {
            liquidShader.destroy();
        }
        if (liquidVAO != null) {
            liquidVAO.destroy();
        }
        if (liquidDepthCopy != null) {
            liquidDepthCopy.close();
        }
        if (emptyVAO != null) {
            emptyVAO.destroy();
        }
        if (blurEffect != null) {
            blurEffect.destroy();
        }
    }

    private /* synthetic */ void lambda$render$0() {
        this.needsInstanceUpdate = true;
    }

    static {
        liquidlight = new byte[400];
        liquidpos = new float[400];
        liquidposnew = new float[400];
    }
}

