/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.FloatBuffer;
import java.util.Collections;
import javax.annotation.Nullable;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.mixins.ocean.MixinLightTextureAccessor;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Pack;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.render.shader.PhysicsShaderExtension;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.class_10799;
import net.minecraft.class_10859;
import net.minecraft.class_10866;
import net.minecraft.class_10867;
import net.minecraft.class_10868;
import net.minecraft.class_12134;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;

public class SmokeRenderer {
    private MainRenderer mainRenderer;
    public static GpuTexture smokeDepthCopy;
    public static VAO smokeVAO;
    private float[] smokepos = new float[400];
    private float[] smokeposnew = new float[400];
    private byte[] smokelight = new byte[400];
    private int count;
    private boolean needsSmokeUpdate = false;
    private int smokeActiveTexture;
    private int lightmapActiveTexture;
    private int depthActiveTexture;
    private Matrix4f tmpMatrix = new Matrix4f();

    public SmokeRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(PhysicsWorld physics, class_638 level, Matrix4fStack viewMatrixStack, class_243 cameraPos) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private RenderPass bindSmokeShader() {
        RenderPipeline renderPipeline = class_10799.field_56903;
        class_10867 customPipeline = null;
        if (StarterClient.iris && Iris.isExtending()) {
            if (Iris.isShadowPass()) {
                if (Iris.getSmokeShadowProgram() == null) return null;
                customPipeline = new class_10867(renderPipeline, Iris.getSmokeShadowProgram());
            } else {
                if (Iris.getSmokeProgram() == null) return null;
                customPipeline = new class_10867(renderPipeline, Iris.getSmokeProgram());
            }
        } else if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            renderPipeline = PhysicsShaders.PHYSICS_SMOKE_PIPELINE;
        }
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60025);
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Smoke", renderPipeline, customPipeline);
        RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
        class_10866 glRenderPass = (class_10866)renderPass;
        glRenderPass.field_57877.method_68351(glRenderPass, Collections.emptyList());
        return renderPass;
    }

    private void setupSmokeRendering(PhysicsWorld physics, class_638 level, Matrix4f modelView, RenderPass renderPass, GpuTextureView smokeTexture, class_243 cameraPos, SmokeDrawCall drawCall) {
        FloatBuffer matrixBuffer;
        MemoryStack stack;
        class_5944 program = ((class_10866)renderPass).field_57868.comp_3802();
        class_284.class_11272 dynamicTransforms = (class_284.class_11272)program.method_34582("DynamicTransforms");
        if (dynamicTransforms != null) {
            GpuBufferSlice slice = drawCall.transform;
            GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.comp_4150(), (int)((class_10859)slice.buffer()).field_57842, (long)slice.offset(), (long)slice.length());
        }
        if (StarterClient.iris) {
            Iris.setNormalMatrix(renderPass, (Matrix4fc)modelView);
        }
        drawCall.bindPBRTextures();
        if (StarterClient.iris && Iris.isExtending()) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_TERRAIN_SHADER.getAttribute(), (float)0.5f, (float)0.5f);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_TERRAIN_SHADER.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        } else if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.5f, (float)0.5f);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((class_10868)smokeTexture.texture()).method_68427());
        GL33C.glBindSampler((int)0, (int)((class_12134)MainRenderer.NEAREST_SAMPLER).method_75285());
        GlStateManager._activeTexture((int)(33984 + this.smokeActiveTexture));
        GlStateManager._bindTexture((int)((class_10868)smokeTexture.texture()).method_68427());
        GL33C.glBindSampler((int)this.smokeActiveTexture, (int)((class_12134)MainRenderer.NEAREST_SAMPLER).method_75285());
        GlStateManager._activeTexture((int)(33984 + this.depthActiveTexture));
        GlStateManager._bindTexture((int)((class_10868)smokeDepthCopy).method_68427());
        GL33C.glBindSampler((int)this.depthActiveTexture, (int)MainRenderer.TEXTURE_NEAREST_CLAMP_SAMPLER);
        int lightmapTextureID = ((class_10868)((MixinLightTextureAccessor)class_310.method_1551().field_1773.method_22974()).getTarget()).method_68427();
        GlStateManager._activeTexture((int)(33984 + this.lightmapActiveTexture));
        GlStateManager._bindTexture((int)lightmapTextureID);
        GL33C.glBindSampler((int)this.lightmapActiveTexture, (int)((class_12134)MainRenderer.LINEAR_CLAMP_SAMPLER).method_75285());
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
        Vector3d physicsOffset = physics.getOffset();
        PhysicsShaderExtension shaderExtension = (PhysicsShaderExtension)program;
        int depthLocation = shaderExtension.physicsmod$getUniformLocation("physics_depth");
        int invProjLocation = shaderExtension.physicsmod$getUniformLocation("physics_invProjectionMatrix");
        int invViewLocation = shaderExtension.physicsmod$getUniformLocation("physics_invViewMatrix");
        int viewLocation = shaderExtension.physicsmod$getUniformLocation("physics_viewMatrix");
        int projLocation = shaderExtension.physicsmod$getUniformLocation("physics_projectionMatrix");
        int cameraOffsetLocation = shaderExtension.physicsmod$getUniformLocation("physics_cameraOffset");
        int renderPercentLocation = shaderExtension.physicsmod$getUniformLocation("physics_renderPercent");
        int smokeLocation = shaderExtension.physicsmod$getUniformLocation("physics_smokeSampler");
        int lightmapLocation = shaderExtension.physicsmod$getUniformLocation("physics_lightmap");
        int smokeColorLocation = shaderExtension.physicsmod$getUniformLocation("physics_smokeColor");
        int smokeDenseColorLocation = shaderExtension.physicsmod$getUniformLocation("physics_smokeDenseColor");
        int smokeDensityLocation = shaderExtension.physicsmod$getUniformLocation("physics_smokeDensity");
        if (depthLocation != -1) {
            GL32C.glUniform1i((int)depthLocation, (int)this.depthActiveTexture);
        }
        if (cameraOffsetLocation != -1) {
            GL32C.glUniform3f((int)cameraOffsetLocation, (float)((float)(cameraPos.field_1352 - physicsOffset.x)), (float)((float)(cameraPos.field_1351 - physicsOffset.y)), (float)((float)(cameraPos.field_1350 - physicsOffset.z)));
        }
        if (renderPercentLocation != -1) {
            GL32C.glUniform1f((int)renderPercentLocation, (float)((float)physics.getRenderPercent()));
        }
        if (lightmapLocation != -1) {
            GL32C.glUniform1i((int)lightmapLocation, (int)this.lightmapActiveTexture);
        }
        if (smokeLocation != -1) {
            GL32C.glUniform1i((int)smokeLocation, (int)this.smokeActiveTexture);
        }
        if (smokeColorLocation != -1) {
            GL32C.glUniform3f((int)smokeColorLocation, (float)ConfigClient.smokeColorRed, (float)ConfigClient.smokeColorGreen, (float)ConfigClient.smokeColorBlue);
        }
        if (smokeDenseColorLocation != -1) {
            GL32C.glUniform3f((int)smokeDenseColorLocation, (float)ConfigClient.smokeDenseColorRed, (float)ConfigClient.smokeDenseColorGreen, (float)ConfigClient.smokeDenseColorBlue);
        }
        if (smokeDensityLocation != -1) {
            GL32C.glUniform1f((int)smokeDensityLocation, (float)ConfigClient.smokeDensity);
        }
        if (projLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                this.mainRenderer.projectionMatrix.get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)projLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (invProjLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                this.mainRenderer.projectionMatrix.invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invProjLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (invViewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invViewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (viewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)viewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        GlStateManager._activeTexture((int)33984);
    }

    private void updateSmokeInstances(SmokeDomain smokeDomain, class_243 cameraPos) {
        if (smokeVAO == null) {
            this.createSmokeVAO(PhysicsMod.smoke);
        }
        this.checkSmokeArrays(smokeDomain.particleCount() * 4);
        this.count = smokeDomain.fillInstances(cameraPos, this.smokepos, this.smokeposnew, this.smokelight);
        smokeVAO.bind();
        smokeVAO.updateAttribute(Data.SMOKE_LIGHT, this.smokelight, this.count * 4);
        smokeVAO.updateAttribute(Data.SMOKE_POS, this.smokepos, this.count * 4);
        smokeVAO.updateAttribute(Data.SMOKE_POS_NEW, this.smokeposnew, this.count * 4);
    }

    private void checkSmokeArrays(int neededSize) {
        int size;
        boolean changed = false;
        for (size = this.smokelight.length; neededSize > size; size *= 2) {
            changed = true;
        }
        if (changed) {
            this.smokelight = new byte[size];
            this.smokepos = new float[size];
            this.smokeposnew = new float[size];
        }
    }

    private void createSmokeVAO(Mesh mesh) {
        int size = mesh.indices.size();
        if (smokeVAO == null) {
            net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
            this.mainRenderer.checkArrays(size);
            for (int i = 0; i < size; ++i) {
                int index = mesh.indices.getInt(i);
                Vector3f p = mesh.positions.get(index);
                Vector2f uv = mesh.uvs.get(index);
                Vector3f normal = mesh.normals.get(index);
                this.mainRenderer.mcol[i] = -1;
                int cp = i * 3;
                this.mainRenderer.mpos[cp] = p.x;
                this.mainRenderer.mpos[cp + 1] = p.y;
                this.mainRenderer.mpos[cp + 2] = p.z;
                int cu = i * 2;
                this.mainRenderer.muv[cu] = uv.x;
                this.mainRenderer.muv[cu + 1] = uv.y;
                this.mainRenderer.mnormals[i] = Pack.normal(normal.x, normal.y, normal.z);
            }
            openglMesh.set(this.mainRenderer.mpos, Data.POSITION);
            openglMesh.set(this.mainRenderer.mcol, Data.COLOR);
            openglMesh.set(this.mainRenderer.muv, Data.TEX_COORD);
            openglMesh.set(this.mainRenderer.mnormals, Data.NORMAL);
            openglMesh.set(this.smokelight, Data.SMOKE_LIGHT);
            openglMesh.set(this.smokepos, Data.SMOKE_POS);
            openglMesh.set(this.smokeposnew, Data.SMOKE_POS_NEW);
            openglMesh.setSize(Data.POSITION, size * 3);
            openglMesh.setSize(Data.COLOR, size);
            openglMesh.setSize(Data.TEX_COORD, size * 2);
            openglMesh.setSize(Data.NORMAL, size);
            openglMesh.setSize(Data.INDEX, size);
            smokeVAO = openglMesh.constructVAO(Usage.DYNAMIC);
        }
    }

    public static void destroy() {
        if (smokeVAO != null) {
            smokeVAO.destroy();
        }
        if (smokeDepthCopy != null) {
            smokeDepthCopy.close();
        }
    }

    private /* synthetic */ void lambda$render$0() {
        this.needsSmokeUpdate = true;
    }

    public class SmokeDrawCall
    extends PBRDrawCall {
        public GpuBufferSlice transform;

        public SmokeDrawCall(SmokeRenderer this$0) {
        }
    }
}

