/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.math.Axis;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Matrix4d;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class OceanPhysicsDisplacementConstraint
extends RenderConstraint {
    private Entity entity;
    private Matrix4d gravityTransformation;
    private Vector3d gravity;

    public OceanPhysicsDisplacementConstraint(Entity entity) {
        this.entity = entity;
        this.gravityTransformation = new Matrix4d();
        this.gravity = new Vector3d();
    }

    @Override
    public void render(Matrix4fStack matrixStack, double renderPercent, VerletSimulation simulation) {
        super.render(matrixStack, renderPercent, simulation);
    }

    private void calculateGravityTransformation(double renderPercent) {
        float actualYRot = 0.0f;
        Entity vehicle = this.entity.getVehicle();
        EntityOcean entityOcean = (EntityOcean)this.entity;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            actualYRot = Mth.rotLerp((float)((float)renderPercent), (float)living.yBodyRotO, (float)living.yBodyRot);
        } else {
            actualYRot = this.entity.getViewYRot((float)renderPercent);
        }
        float currentYRot = (float)(-Math.toRadians(actualYRot - (float)Math.PI));
        double forwardZ = Math.cos(currentYRot);
        double forwardX = Math.sin(currentYRot);
        double leftX = forwardZ;
        double leftZ = -forwardX;
        double roll = entityOcean.getPhysicsRoll((float)renderPercent);
        double pitch = entityOcean.getPhysicsPitch((float)renderPercent);
        float diffRot = 0.0f;
        if (vehicle != null && vehicle instanceof Boat) {
            diffRot = vehicle.getViewYRot((float)renderPercent) - actualYRot;
        }
        this.gravityTransformation.identity();
        this.gravityTransformation.rotate((Quaternionfc)Axis.YP.rotationDegrees(-diffRot));
        this.gravityTransformation.rotate((Quaternionfc)Axis.of((Vector3f)new Vector3f((float)forwardX, 0.0f, (float)forwardZ)).rotationDegrees((float)(-Math.toDegrees(roll))));
        this.gravityTransformation.rotate((Quaternionfc)Axis.of((Vector3f)new Vector3f((float)leftX, 0.0f, (float)leftZ)).rotationDegrees((float)Math.toDegrees(pitch)));
        this.gravityTransformation.invert();
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        super.updateBefore(delta, simulation);
        this.gravity.set((Vector3dc)simulation.getGravity());
        this.gravityTransformation.transformDirection(simulation.getGravity());
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        super.updateAfter(delta, simulation);
        simulation.setGravity(this.gravity);
    }
}

