/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.compat.Sodium;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.minecraft.DynamicUniformsExtension;
import net.diebuddies.minecraft.LightUniform;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.opengl.VertexFormat;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.render.ClothRenderer;
import net.diebuddies.render.DebugRenderer;
import net.diebuddies.render.DynamicUniformStorageExtension;
import net.diebuddies.render.LiquidDeferredRenderer;
import net.diebuddies.render.LiquidRenderer;
import net.diebuddies.render.OceanRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.render.PhysicsUpdater;
import net.diebuddies.render.SmokeRenderer;
import net.diebuddies.render.SnowRenderer;
import net.diebuddies.render.TransparencyRenderer;
import net.diebuddies.render.shader.PhysicsShaders;
import net.diebuddies.util.DoublyLinkedList;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PerspectiveProjectionMatrixBuffer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.FrustumIntersection;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryUtil;

public class MainRenderer {
    private static final int DEFAULT_SIZE = 200;
    public static final Matrix4f IDENTITY_4_BY_4 = new Matrix4f();
    public static final Vector4f WHITE = new Vector4f(1.0f);
    public static final Vector3f ZERO = new Vector3f(0.0f);
    public static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    public static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, 1.0f, 0.7f).normalize();
    public static final Vector3f NETHER_DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    public static final Vector3f NETHER_DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, -1.0f, 0.7f).normalize();
    public Vector3f lightDirection0 = new Vector3f();
    public Vector3f lightDirection1 = new Vector3f();
    public int size = 200;
    public float[] mpos = new float[this.size * 3];
    public int[] mcol = new int[this.size];
    public float[] muv = new float[this.size * 2];
    public int[] mnormals = new int[this.size];
    public float[] mmidtexcoord = new float[this.size * 2];
    public int[] mtangent = new int[this.size];
    public static PerspectiveProjectionMatrixBuffer levelProjectionMatrixBuffer;
    public FrustumIntersection frustumInt = new FrustumIntersection();
    private Matrix4f viewProjectionMatrix = new Matrix4f();
    public Matrix4f projectionMatrix = new Matrix4f();
    public Matrix4f viewMatrix = new Matrix4f();
    private Matrix4f transformation = new Matrix4f();
    private Matrix3f normalMatrix = new Matrix3f();
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    private Matrix4f currentPose = new Matrix4f();
    private List<PhysicsDrawCall> drawCalls;
    private PhysicsUpdater physicsUpdater = new PhysicsUpdater();
    private DebugRenderer debugRenderer = new DebugRenderer(this);
    private SmokeRenderer smokeRenderer = new SmokeRenderer(this);
    private SnowRenderer snowRenderer = new SnowRenderer(this);
    public OceanRenderer oceanRenderer = new OceanRenderer(this);
    public LiquidDeferredRenderer liquidDeferredRenderer;
    private LiquidRenderer liquidRenderer = new LiquidRenderer(this);
    private ClothRenderer clothRenderer;
    private TransparencyRenderer transparencyRenderer;
    public static FloatBuffer matrixBuffer;
    public static FloatBuffer identityMatrixBuffer;
    public static FloatBuffer vector4Buffer;
    public static FloatBuffer vector3Buffer;
    public static MultiBufferSource.BufferSource bufferSource;

    public MainRenderer() {
        this.liquidDeferredRenderer = new LiquidDeferredRenderer(this);
        this.transparencyRenderer = new TransparencyRenderer(this);
        this.clothRenderer = new ClothRenderer(this);
        this.drawCalls = new ObjectArrayList();
        if (matrixBuffer == null) {
            bufferSource = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(786432));
            levelProjectionMatrixBuffer = new PerspectiveProjectionMatrixBuffer("Physics Mod Projection");
            matrixBuffer = MemoryUtil.memAllocFloat((int)16);
            identityMatrixBuffer = MemoryUtil.memAllocFloat((int)16);
            vector4Buffer = MemoryUtil.memAllocFloat((int)4);
            vector3Buffer = MemoryUtil.memAllocFloat((int)3);
            IDENTITY_4_BY_4.get(identityMatrixBuffer);
        }
    }

    public void setMatrices(Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        this.projectionMatrix.set((Matrix4fc)projectionMatrix);
        this.viewMatrix.set((Matrix4fc)viewMatrix);
        this.projectionMatrix.mul((Matrix4fc)this.viewMatrix, this.viewProjectionMatrix);
        this.frustumInt.set((Matrix4fc)this.viewProjectionMatrix, true);
        PhysicsMod.projectionMatrix.set((Matrix4fc)projectionMatrix);
        PhysicsMod.viewMatrix.set((Matrix4fc)viewMatrix);
    }

    public void renderAll(ClientLevel level, ChunkSectionLayer chunkSectionLayer) {
        boolean requiresRender;
        RenderSystem.assertOnRenderThread();
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        textureManager.getTexture(PhysicsMod.WHITE_TEXTURE);
        textureManager.getTexture(PhysicsMod.SNOWBALL_TEXTURE);
        textureManager.getTexture(PhysicsMod.ENDERPEARL_TEXTURE);
        textureManager.getTexture(PhysicsMod.EGG_TEXTURE);
        textureManager.getTexture(PhysicsMod.SMOKE_TEXTURE);
        textureManager.getTexture(PhysicsMod.PUDDLE_TEXTURE);
        this.verifyAndUtility();
        if (level == null) {
            return;
        }
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        PhysicsMod mod = PhysicsMod.getInstance((Level)level);
        PhysicsWorld physics = mod.getPhysicsWorld();
        physics.updateLastSeen();
        this.physicsUpdater.updatePhysics(mod, level, view, physics);
        boolean bl = physics.getBodies().size() > 0 || physics.getRagdolls().size() > 0 || physics.getSnowWorld().getChunks().size() > 0 || physics.getSmokeDomain().particleCount() > 0 ? true : (requiresRender = false);
        if (!requiresRender) {
            return;
        }
        PerformanceTracker.startNoFlush("blocks_mobs_particles_rendering");
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)levelProjectionMatrixBuffer.getBuffer(this.projectionMatrix), (ProjectionType)ProjectionType.PERSPECTIVE);
        Matrix4fStack viewMatrixStack = RenderSystem.getModelViewStack();
        viewMatrixStack.pushMatrix();
        viewMatrixStack.set((Matrix4fc)this.viewMatrix);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        Minecraft.getInstance().gameRenderer.overlayTexture().setupOverlayColor();
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.LEVEL);
        GlStateManager._activeTexture((int)33984);
        VAO.storePreviouslyBoundState();
        Vector3d physicsOffset = physics.getOffset();
        double offsetX = physicsOffset.x - view.x;
        double offsetY = physicsOffset.y - view.y;
        double offsetZ = physicsOffset.z - view.z;
        boolean isShadowPass = StarterClient.iris && Iris.isExtending() && Iris.isShadowPass() || StarterClient.optifabric && Optifine.isShadowPass();
        physics.bindForRendering();
        this.createPhysicsModels(physics);
        DoublyLinkedList<IRigidBody> bodies = physics.getBodies();
        Iterator<IRigidBody> it = bodies.iterator();
        int size = bodies.size();
        for (int i = 0; i < size; ++i) {
            IRigidBody body = it.next();
            PhysicsRenderable entity = body.getEntity();
            if (entity.models == null) continue;
            this.setTransformation(physics, body, entity, isShadowPass);
            this.queueDrawCall(physics, level, viewMatrixStack, view, offsetX, offsetY, offsetZ, body, entity, false);
        }
        this.uploadDrawCallTransforms();
        RenderPass renderPass = this.bindProperShader(() -> "Physics Mod Solid", this.getProperSolidRenderPipeline());
        this.setupShader(renderPass);
        physics.bindForRendering();
        this.executeDrawCalls(renderPass, this.viewMatrix, physics.format);
        renderPass.close();
        StateTracker.unbindVertexArray();
        PerformanceTracker.end("blocks_mobs_particles_rendering");
        this.snowRenderer.render(physics, level, viewMatrixStack, view);
        this.smokeRenderer.render(physics, level, viewMatrixStack, view);
        this.transparencyRenderer.render(physics, level, viewMatrixStack, view);
        VAO.restorePreviouslyBoundState();
        viewMatrixStack.popMatrix();
        GlStateManager._activeTexture((int)33984);
        GlStateManager._enableCull();
        RenderSystem.restoreProjectionMatrix();
    }

    public RenderPipeline getProperSolidRenderPipeline() {
        boolean useCustomShader = true;
        if (StarterClient.iris && Iris.isExtending()) {
            useCustomShader = false;
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            useCustomShader = false;
        }
        if (useCustomShader) {
            return PhysicsShaders.PHYSICS_ENTITY_PIPELINE;
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.useEntityShader();
        }
        return RenderPipelines.ARMOR_CUTOUT_NO_CULL;
    }

    public RenderPass bindProperShader(Supplier<String> passName, RenderPipeline pipeline, @Nullable GlRenderPipeline customPipeline) {
        RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
        RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(passName, renderTarget.getColorTextureView(), OptionalInt.empty(), renderTarget.getDepthTextureView(), OptionalDouble.empty());
        if (customPipeline == null) {
            renderPass.setPipeline(pipeline);
        } else {
            ((GlRenderPass)renderPass).pipeline = customPipeline;
        }
        for (int j = 0; j < 12; ++j) {
            GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)j);
            if (gpuTexture == null) continue;
            renderPass.bindSampler("Sampler" + j, gpuTexture);
        }
        RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
        return renderPass;
    }

    public RenderPass bindProperShader(Supplier<String> passName, RenderPipeline pipeline) {
        return this.bindProperShader(passName, pipeline, null);
    }

    public void setupShader(RenderPass renderPass) {
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        if (StarterClient.iris) {
            Iris.resetPBRUnits();
        }
        glRenderPass.encoder.trySetup(glRenderPass, Collections.emptyList());
    }

    private void createPhysicsModels(PhysicsWorld physics) {
        Set<PhysicsRenderable> bodies = physics.getQueueForModelCreation();
        Iterator<PhysicsRenderable> it = bodies.iterator();
        int size = bodies.size();
        block0: for (int i = 0; i < size; ++i) {
            PhysicsRenderable entity = it.next();
            List<Model> models = entity.models;
            if (entity.models == null) continue;
            int modelsSize = models.size();
            for (int j = 0; j < modelsSize; ++j) {
                Model model = models.get(j);
                boolean shade = entity.shade;
                Mesh mesh = model.mesh;
                if (mesh == null || mesh.indices.size() < 3) continue block0;
                if (model.memorySegment != null) continue;
                entity.getBoundingSphereRadius();
                model.createModelMemorySegment(physics, shade);
            }
        }
        bodies.clear();
    }

    public void setTransformation(PhysicsWorld physics, IRigidBody body, PhysicsRenderable entity, boolean isShadowPass) {
        if (isShadowPass) {
            return;
        }
        if (body.hasTransformationChanged()) {
            MatrixUtil.slerp(entity, (float)physics.getRenderPercent(), entity.getRenderTransformation());
        }
    }

    public void queueDrawCall(PhysicsWorld physics, ClientLevel level, Matrix4fStack viewMatrix, Vec3 view, double offsetX, double offsetY, double offsetZ, IRigidBody body, PhysicsRenderable particle, boolean renderTransparency) {
        List<Model> models = particle.models;
        Model modelZero = models.get(0);
        if (modelZero.memorySegment == null) {
            return;
        }
        Matrix4f renderTransformation = particle.getRenderTransformation();
        this.transformation.set3x3((Matrix4fc)particle.getRenderTransformation());
        float posx = (float)((double)renderTransformation.m30() + offsetX);
        float posy = (float)((double)renderTransformation.m31() + offsetY);
        float posz = (float)((double)renderTransformation.m32() + offsetZ);
        this.transformation.setTranslation(posx, posy, posz);
        if (!renderTransparency && !this.frustumInt.testSphere(posx, posy, posz, particle.getBoundingSphereRadius())) {
            return;
        }
        double animationScale = particle.getDespawnScale((Level)level);
        float alpha = 1.0f;
        if (particle.getAnimationType() == AnimationType.Vanish) {
            alpha = Math.min(1.0f, (float)animationScale);
            animationScale = 1.0;
        } else if (particle.getAnimationType() == AnimationType.Shrink_and_Vanish) {
            alpha = Math.min(1.0f, (float)animationScale);
        }
        if ((alpha < 1.0f || particle.translucent) && !renderTransparency) {
            this.transparencyRenderer.addTransparentObject(body, Vector3f.lengthSquared((float)posx, (float)posy, (float)posz));
            return;
        }
        this.transformation.scale((float)animationScale);
        this.blockPos.set((double)posx + view.x, (double)posy + view.y, (double)posz + view.z);
        viewMatrix.mulAffine((Matrix4fc)this.transformation, this.currentPose);
        LightUniform light = this.setupLighting(this.transformation, level, particle.shade);
        int size = models.size();
        int brightness = particle.getLight((Level)level, this.blockPos);
        for (int j = 0; j < size; ++j) {
            Model model = models.get(j);
            if (model.memorySegment == null) continue;
            DynamicUniforms.Transform transform = MainRenderer.createTransformUniform(this.currentPose, particle.getRed(), particle.getGreen(), particle.getBlue(), alpha, model.textureMatrix);
            if (StarterClient.sodium && model.animationSprite != null) {
                Sodium.markSpriteActive(model.animationSprite);
            }
            PhysicsDrawCall drawCall = new PhysicsDrawCall(this);
            drawCall.transform = transform;
            drawCall.light = light;
            drawCall.texture = model.textureID;
            drawCall.brightness = brightness;
            drawCall.backfaceCulling = particle.backfaceCulling;
            drawCall.shade = particle.shade;
            drawCall.segment = model.memorySegment;
            drawCall.fetchPBRTextures(drawCall.texture);
            this.drawCalls.add(drawCall);
        }
    }

    public void uploadDrawCallTransforms() {
        DynamicUniformsExtension dynamicUniforms = (DynamicUniformsExtension)RenderSystem.getDynamicUniforms();
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getDynamicUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.transform, (drawCall, gpuSlice) -> {
            drawCall.transformBuffer = gpuSlice;
        });
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getLightUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.light, (drawCall, gpuSlice) -> {
            drawCall.lightBuffer = gpuSlice;
        });
    }

    public void executeDrawCalls(RenderPass renderPass, Matrix4f viewMatrix, VertexFormat format) {
        int size = this.drawCalls.size();
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        GlProgram program = glRenderPass.pipeline.program();
        Uniform.Ubo dynamicTransforms = (Uniform.Ubo)program.getUniform("DynamicTransforms");
        Uniform.Ubo lighting = (Uniform.Ubo)program.getUniform("Lighting");
        Matrix3f cameraNormalMatrix = viewMatrix.normal(new Matrix3f());
        int lastBrightness = Integer.MAX_VALUE;
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        for (int i = 0; i < size; ++i) {
            GpuBufferSlice slice;
            PhysicsDrawCall drawCall = this.drawCalls.get(i);
            if (StarterClient.iris) {
                if (drawCall.shade) {
                    Iris.setNormalMatrix(renderPass, (Matrix4fc)new Matrix4f(drawCall.transform.modelView()));
                } else {
                    Iris.setNormalMatrix(renderPass, (Matrix4fc)new Matrix4f(drawCall.transform.modelView()), (Matrix3fc)cameraNormalMatrix);
                }
            }
            GpuTextureView glID = drawCall.texture;
            GlStateManager._activeTexture((int)33984);
            GlStateManager._bindTexture((int)((GlTexture)glID.texture()).glId());
            ((GlTexture)glID.texture()).flushModeChanges(3553);
            drawCall.bindPBRTextures();
            if (drawCall.backfaceCulling) {
                GlStateManager._enableCull();
            } else {
                GlStateManager._disableCull();
            }
            if (dynamicTransforms != null) {
                slice = drawCall.transformBuffer;
                GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.blockBinding(), (int)((GlBuffer)slice.buffer()).handle, (long)slice.offset(), (long)slice.length());
            }
            if (lighting != null) {
                slice = drawCall.lightBuffer;
                GL32C.glBindBufferRange((int)35345, (int)lighting.blockBinding(), (int)((GlBuffer)slice.buffer()).handle, (long)slice.offset(), (long)slice.length());
            }
            int brightness = drawCall.brightness;
            ArenaBuffer.MemorySegment segment = drawCall.segment;
            if (lastBrightness != brightness) {
                GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(brightness & 0xF0), (int)(brightness >> 16 & 0xF0));
            }
            lastBrightness = brightness;
            GL32C.glDrawArrays((int)4, (int)(segment.offset / format.getStride()), (int)(segment.size / format.getStride()));
        }
        this.drawCalls.clear();
    }

    public LightUniform setupLighting(Matrix4f transformation, ClientLevel level, boolean shade) {
        if (shade) {
            Matrix3f lightMatrix = transformation.normal(this.normalMatrix).invert();
            if (level.effects().constantAmbientLight()) {
                lightMatrix.transform((Vector3fc)NETHER_DIFFUSE_LIGHT_0, this.lightDirection0);
                lightMatrix.transform((Vector3fc)NETHER_DIFFUSE_LIGHT_1, this.lightDirection1);
            } else {
                lightMatrix.transform((Vector3fc)DIFFUSE_LIGHT_0, this.lightDirection0);
                lightMatrix.transform((Vector3fc)DIFFUSE_LIGHT_1, this.lightDirection1);
            }
            return new LightUniform((Vector3fc)new Vector3f((Vector3fc)this.lightDirection0), (Vector3fc)new Vector3f((Vector3fc)this.lightDirection1));
        }
        if (level.effects().constantAmbientLight()) {
            return new LightUniform((Vector3fc)new Vector3f((Vector3fc)NETHER_DIFFUSE_LIGHT_0), (Vector3fc)new Vector3f((Vector3fc)NETHER_DIFFUSE_LIGHT_1));
        }
        return new LightUniform((Vector3fc)new Vector3f((Vector3fc)DIFFUSE_LIGHT_0), (Vector3fc)new Vector3f((Vector3fc)DIFFUSE_LIGHT_1));
    }

    public static DynamicUniforms.Transform createTransformUniform(Matrix4f transformation, float r, float g, float b, float a, @Nullable Matrix4f textureMatrix) {
        return new DynamicUniforms.Transform((Matrix4fc)new Matrix4f((Matrix4fc)transformation), (Vector4fc)new Vector4f(r, g, b, a), (Vector3fc)ZERO, (Matrix4fc)(textureMatrix == null ? IDENTITY_4_BY_4 : new Matrix4f((Matrix4fc)textureMatrix)), 1.0f);
    }

    public static DynamicUniforms.Transform createTransformUniform(Matrix4f transformation) {
        return new DynamicUniforms.Transform((Matrix4fc)new Matrix4f((Matrix4fc)transformation), (Vector4fc)WHITE, (Vector3fc)ZERO, (Matrix4fc)IDENTITY_4_BY_4, 1.0f);
    }

    public void checkArrays(int neededSize) {
        boolean changed = false;
        while (neededSize > this.size) {
            this.size *= 2;
            changed = true;
        }
        if (changed) {
            this.mpos = new float[this.size * 3];
            this.mcol = new int[this.size];
            this.muv = new float[this.size * 2];
            this.mnormals = new int[this.size];
            this.mmidtexcoord = new float[this.size * 2];
            this.mtangent = new int[this.size];
        }
    }

    public void renderDynamicCloth(ClientLevel level) {
        this.clothRenderer.renderDynamicCloth(level, this.viewMatrix, this.projectionMatrix);
    }

    public void renderStaticCloth(ClientLevel level) {
        this.clothRenderer.renderStaticCloth(level, this.viewMatrix, this.projectionMatrix);
    }

    public void renderLiquid(ClientLevel level, ChunkSectionLayer chunkSectionLayer) {
        this.liquidRenderer.render(level, chunkSectionLayer, this.viewMatrix, this.projectionMatrix);
    }

    public void verifyAndUtility() {
        MutableComponent comp;
        JsonElement jsonElement;
        if (StarterClient.updateMessage != null && !StarterClient.updateMessage.isBlank() && Minecraft.getInstance().player != null) {
            jsonElement = StrictJsonParser.parse((String)StarterClient.updateMessage);
            comp = ComponentSerialization.CODEC.parse((DynamicOps)Minecraft.getInstance().player.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).resultOrPartial(string2 -> StarterClient.logger.warn("Failed to parse custom message '{}': {}", (Object)StarterClient.updateMessage, string2)).orElse(null);
            Minecraft.getInstance().player.displayClientMessage((Component)comp, false);
            StarterClient.updateMessage = "";
        }
        if (StarterClient.customMessage != null && !StarterClient.customMessage.isBlank() && Minecraft.getInstance().player != null) {
            jsonElement = StrictJsonParser.parse((String)StarterClient.customMessage);
            comp = ComponentSerialization.CODEC.parse((DynamicOps)Minecraft.getInstance().player.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).resultOrPartial(string2 -> StarterClient.logger.warn("Failed to parse custom message '{}': {}", (Object)StarterClient.customMessage, string2)).orElse(null);
            Minecraft.getInstance().player.displayClientMessage((Component)comp, false);
            StarterClient.customMessage = "";
        }
    }

    public static void destroy() {
        SmokeRenderer.destroy();
        TransparencyRenderer.destroy();
        OceanRenderer.destroy();
        LiquidDeferredRenderer.destroy();
        if (levelProjectionMatrixBuffer != null) {
            levelProjectionMatrixBuffer.close();
        }
        if (matrixBuffer != null) {
            MemoryUtil.memFree((Buffer)matrixBuffer);
        }
        if (identityMatrixBuffer != null) {
            MemoryUtil.memFree((Buffer)identityMatrixBuffer);
        }
        if (vector4Buffer != null) {
            MemoryUtil.memFree((Buffer)vector4Buffer);
        }
        if (vector3Buffer != null) {
            MemoryUtil.memFree((Buffer)vector3Buffer);
        }
    }

    private class PhysicsDrawCall
    extends PBRDrawCall {
        public DynamicUniforms.Transform transform;
        public LightUniform light;
        public GpuTextureView texture;
        public int brightness;
        public boolean backfaceCulling;
        public boolean shade;
        public ArenaBuffer.MemorySegment segment;
        public GpuBufferSlice transformBuffer;
        public GpuBufferSlice lightBuffer;

        private PhysicsDrawCall(MainRenderer mainRenderer) {
        }
    }
}

