/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public class RainParticle
extends WeatherParticle {
    private Quaternionf movementRotation = new Quaternionf();

    public RainParticle(ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz, TextureAtlasSprite sprite) {
        super(clientLevel, x, y, z, vx, vy, vz, sprite);
        this.quadSize = 0.23f;
        this.setColor(255, 255, 255, (int)((float)(175 + (int)((double)Math.random() * 40.0)) * ConfigClient.particleRainOpacity));
        double lengthSquared = Vector3d.lengthSquared((double)vx, (double)vy, (double)vz);
        if (lengthSquared != 0.0) {
            double invLength = 1.0 / org.joml.Math.sqrt((double)lengthSquared);
            vx *= invLength;
            vy *= invLength;
            vz *= invLength;
        } else {
            vy = -1.0;
        }
        this.dampingX = 1.0;
        this.dampingY = 1.0;
        this.dampingZ = 1.0;
        this.gravity = 0.0f;
        this.rotationTo(this.movementRotation, (float)vx, (float)vy, (float)vz).rotateX((float)((double)Math.random() * 10.0));
    }

    public Quaternionf rotationTo(Quaternionf src, float tx, float ty, float tz) {
        float dot = -tx;
        if (dot < -0.999999f) {
            src.x = 0.0f;
            src.y = 1.0f;
            src.z = 0.0f;
            src.w = 0.0f;
        } else {
            float sd2 = org.joml.Math.sqrt((float)((1.0f + dot) * 2.0f));
            float isd2 = 1.0f / sd2;
            float cx = 0.0f;
            float cy = tz;
            float cz = -ty;
            float x = cx * isd2;
            float y = cy * isd2;
            float z = cz * isd2;
            float w = sd2 * 0.5f;
            float n2 = org.joml.Math.invsqrt((float)org.joml.Math.fma((float)x, (float)x, (float)org.joml.Math.fma((float)y, (float)y, (float)org.joml.Math.fma((float)z, (float)z, (float)(w * w)))));
            src.x = x * n2;
            src.y = y * n2;
            src.z = z * n2;
            src.w = w * n2;
        }
        return src;
    }

    public void extract(QuadParticleRenderState quadParticleRenderState, Camera camera, float renderPercent) {
        Vec3 cameraPos = camera.position();
        double px = org.joml.Math.lerp((double)this.xo, (double)this.x, (double)renderPercent);
        double py = org.joml.Math.lerp((double)this.yo, (double)this.y, (double)renderPercent);
        double pz = org.joml.Math.lerp((double)this.zo, (double)this.z, (double)renderPercent);
        float currentX = (float)(px - cameraPos.x());
        float currentY = (float)(py - cameraPos.y());
        float currentZ = (float)(pz - cameraPos.z());
        int light = this.getLightColor(renderPercent);
        quadParticleRenderState.add(this.getLayer(), currentX, currentY, currentZ, this.movementRotation.x, this.movementRotation.y, this.movementRotation.z, this.movementRotation.w, this.quadSize, this.getU0(), this.getU1(), this.getV0(), this.getV1(), this.argb, light);
    }

    @Override
    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
            return new RainParticle(clientLevel, x, y, z, vx, vy, vz, this.sprite.get((RandomSource)Math.fastRandomSource));
        }
    }
}

