/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.PlayerRenderStateExtended;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.ClothRenderState;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.EntityLevelPacked;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.player.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AvatarRenderer.class})
public abstract class MixinPlayerRenderer
extends LivingEntityRenderer<Avatar, AvatarRenderState, PlayerModel> {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> physicsmod$elytraSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private PlayerLevelPacked physicsmod$elytraTmp = new PlayerLevelPacked(null, null);
    @Unique
    private Map<EntityLevelPacked, VerletSimulation> physicsmod$clothSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private EntityLevelPacked physicsmod$clothTmp = new EntityLevelPacked();
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> physicsmod$capeSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private PlayerLevelPacked physicsmod$capeTmp = new PlayerLevelPacked(null, null);

    public MixinPlayerRenderer(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(at={@At(value="TAIL")}, method={"extractRenderState"}, cancellable=true)
    private void physicsmod$extendRenderState(Avatar entity, AvatarRenderState entityRenderState, float tickDelta, CallbackInfo info) {
        this.physicsmod$extraxtClothRenderState(entity, entityRenderState, tickDelta);
    }

    @Unique
    private void physicsmod$extraxtClothRenderState(Avatar entity, AvatarRenderState entityRenderState, float tickDelta) {
        ClothRenderState state = new ClothRenderState();
        ((PlayerRenderStateExtended)entityRenderState).physicsmod$setClothRenderState(state);
        boolean canVersionRenderCloth = Minecraft.getInstance().player != entity;
        this.physicsmod$removeOldSimulations();
        if (PhysicsMod.clothSkipRenderQueue || !canVersionRenderCloth || entityRenderState.isInvisible) {
            return;
        }
        if (ConfigClient.capePhysics) {
            if (!ConfigClient.clothForceArmor) {
                state.skipChestEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.chestEquipment, EquipmentSlot.CHEST);
                state.skipLegsEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.legsEquipment, EquipmentSlot.LEGS);
                state.skipFeetEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.feetEquipment, EquipmentSlot.FEET);
                state.skipHeadEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.headEquipment, EquipmentSlot.HEAD);
            }
            state.hiddenModelParts = ClothConstants.getHiddenParts((Entity)entity);
            ItemStack itemStack = entityRenderState.chestEquipment;
            if (itemStack != null && itemStack.is(Items.ELYTRA)) {
                boolean renderElytra;
                boolean bl = renderElytra = entity != null && !entity.isInvisible() && !ConfigClient.clothForceArmor;
                if (renderElytra && ConfigCloth.hasCategory((Entity)entity, "Elytra")) {
                    this.physicsmod$renderPhysicsElytra(entity, entityRenderState, tickDelta);
                    state.skipElytra = true;
                }
            } else if (entityRenderState.showCape) {
                PlayerSkin playerSkin = entityRenderState.skin;
                if (this.physicsmod$hasPhysicsCape(entity)) {
                    state.skipCape = true;
                } else if (playerSkin.cape() != null) {
                    // empty if block
                }
            }
            this.physicsmod$renderPhysicsCloth(entity, entityRenderState, tickDelta);
        }
    }

    @Unique
    private boolean physicsmod$hasPhysicsCape(Avatar player) {
        return ConfigCloth.hasCategory((Entity)player, "Back");
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        this.physicsmod$removeOldSimulation(this.physicsmod$elytraSimulations);
        this.physicsmod$removeOldSimulation(this.physicsmod$clothSimulations);
        this.physicsmod$removeOldSimulation(this.physicsmod$capeSimulations);
    }

    @Unique
    private <K> void physicsmod$removeOldSimulation(Map<K, VerletSimulation> simulations) {
        Iterator<Map.Entry<K, VerletSimulation>> it = simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private boolean physicsmod$checkSkipArmourRender(Avatar entity, ItemStack itemStack, EquipmentSlot equipmentSlot) {
        Equippable equippable = (Equippable)itemStack.get(DataComponents.EQUIPPABLE);
        if (equippable == null || equippable.slot() != equipmentSlot) {
            return false;
        }
        Map<String, ConfigCloth.ClothList> customizationParts = ConfigCloth.getCustomizationParts((Entity)entity);
        if (customizationParts == null || entity.isInvisible()) {
            return false;
        }
        for (Map.Entry<String, ConfigCloth.ClothList> customizationPart : customizationParts.entrySet()) {
            ConfigCloth.ClothList clothList = customizationPart.getValue();
            for (String clothPiece : clothList.getClothPieces()) {
                Cloth cloth = PhysicsMod.cloth.get(clothPiece);
                if (cloth == null || !cloth.rules.getHiddenArmorPieces().contains(equipmentSlot.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void physicsmod$renderPhysicsElytra(Avatar player, AvatarRenderState rs, float dt) {
        Level level = player.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        this.physicsmod$elytraTmp.e1 = player;
        this.physicsmod$elytraTmp.e2 = level;
        VerletSimulation sim = this.physicsmod$elytraSimulations.get(this.physicsmod$elytraTmp);
        Cloth cloth = ConfigCloth.getCategory((Entity)player, "Elytra");
        int light = Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords((Entity)player, dt);
        EntityModel model = ((LivingEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player)).getModel();
        if (this.physicsmod$shouldRenderFast((LivingEntity)player) || !cloth.rules.isDynamic()) {
            ModelPart mp = ModelPartConstraint.getPart((Model)model, "body");
            if (mp != null) {
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (LivingEntity)player, mp, light));
            }
            return;
        }
        if (sim == null) {
            if (!ModelPartConstraint.exists((Model)model, "body")) {
                return;
            }
            sim = this.physicsmod$buildSimulation(level, (LivingEntity)player, (LivingEntityRenderState)rs, (Model)model, "body", cloth, cloth.getTexture((Entity)player), light);
            this.physicsmod$elytraSimulations.put(new PlayerLevelPacked(player, level), sim);
        } else {
            this.physicsmod$updateSimulation(sim, (LivingEntity)player, (LivingEntityRenderState)rs, (Model)model, light);
            if (cloth != sim.cloth) {
                sim.destroyed = true;
            }
        }
        PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), k -> new ObjectArrayList()).add(sim);
    }

    @Unique
    private void physicsmod$renderPhysicsCloth(Avatar player, AvatarRenderState renderState, float tickDelta) {
        Map<String, ConfigCloth.ClothList> parts = ConfigCloth.getCustomizationParts((Entity)player);
        if (parts == null || player.isInvisible()) {
            return;
        }
        Level level = player.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        int light = Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords((Entity)player, tickDelta);
        for (Map.Entry<String, ConfigCloth.ClothList> e : parts.entrySet()) {
            String modelPart = e.getKey();
            for (String clothId : e.getValue().getClothPieces()) {
                ModelPart mp;
                Cloth cloth = PhysicsMod.cloth.get(clothId);
                if (cloth == null || ClothConstants.doesArmorHideCloth(cloth, (LivingEntity)player) || ClothConstants.isElytraHidingCloth(cloth, modelPart, (LivingEntity)player)) continue;
                if (this.physicsmod$shouldRenderFast((LivingEntity)player) || !cloth.rules.isDynamic()) {
                    ModelPart mp2 = ModelPartConstraint.getPart((Model)this.getModel(), modelPart);
                    if (mp2 == null) continue;
                    PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (LivingEntity)player, mp2, light));
                    continue;
                }
                this.physicsmod$clothTmp.set((Entity)player, modelPart, clothId, level);
                VerletSimulation sim = this.physicsmod$clothSimulations.get(this.physicsmod$clothTmp);
                if (sim == null) {
                    if (!ModelPartConstraint.exists((Model)this.getModel(), modelPart)) continue;
                    sim = this.physicsmod$buildSimulation(level, (LivingEntity)player, (LivingEntityRenderState)renderState, (Model)this.getModel(), modelPart, cloth, cloth.getTexture((Entity)player), light);
                    this.physicsmod$clothSimulations.put(new EntityLevelPacked((Entity)player, modelPart, clothId, level), sim);
                } else {
                    this.physicsmod$updateSimulation(sim, (LivingEntity)player, (LivingEntityRenderState)renderState, (Model)this.getModel(), light);
                    if (cloth != sim.cloth) {
                        sim.destroyed = true;
                    }
                }
                PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), k -> new ObjectArrayList()).add(sim);
                if (cloth.playerMesh == null || (mp = ModelPartConstraint.getPart((Model)this.getModel(), modelPart)) == null) continue;
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (LivingEntity)player, mp, light).setOnlyRenderPlayer(true));
            }
        }
    }

    @Unique
    private void physicsmod$renderPhysicsCape(Avatar player, AvatarRenderState renderState, float tickDelta) {
        Level level = player.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        PlayerSkin skin = renderState.skin;
        this.physicsmod$capeTmp.e1 = player;
        this.physicsmod$capeTmp.e2 = level;
        VerletSimulation simulation = this.physicsmod$capeSimulations.get(this.physicsmod$capeTmp);
        Cloth cloth = PhysicsMod.defaultCape;
        int light = Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords((Entity)player, tickDelta);
        EntityModel model = ((LivingEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player)).getModel();
        if (this.physicsmod$shouldRenderFast((LivingEntity)player) || !cloth.rules.isDynamic()) {
            ModelPart mp = ModelPartConstraint.getPart((Model)model, "body");
            GpuTextureView tex = Minecraft.getInstance().getTextureManager().getTexture(skin.cape().texturePath()).getTextureView();
            if (mp != null) {
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, tex, (LivingEntity)player, mp, light));
            }
            return;
        }
        if (simulation == null) {
            if (!ModelPartConstraint.exists((Model)model, "body")) {
                return;
            }
            Identifier tex = skin.cape().texturePath();
            simulation = this.physicsmod$buildSimulation(level, (LivingEntity)player, (LivingEntityRenderState)renderState, (Model)model, "body", cloth, tex, light);
            this.physicsmod$capeSimulations.put(new PlayerLevelPacked(player, level), simulation);
        } else {
            this.physicsmod$updateSimulation(simulation, (LivingEntity)player, (LivingEntityRenderState)renderState, (Model)model, light);
            if (cloth != simulation.cloth) {
                simulation.destroyed = true;
            }
        }
        PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), key -> new ObjectArrayList()).add(simulation);
    }

    @Unique
    private boolean physicsmod$shouldRenderFast(LivingEntity e) {
        Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
        double r = ConfigClient.clothEntityRange;
        return cam.blockPosition().distSqr((Vec3i)e.blockPosition()) > r * r;
    }

    @Unique
    private void physicsmod$updateSimulation(VerletSimulation sim, LivingEntity entity, LivingEntityRenderState rs, Model model, int light) {
        if (sim.destroyed) {
            return;
        }
        sim.active = true;
        sim.brightness = light;
        sim.getConstraint(ModelPartConstraint.class).updateEntityTransformation(sim, entity, rs, model, 1.0f);
    }

    @Unique
    private VerletSimulation physicsmod$buildSimulation(Level level, LivingEntity entity, LivingEntityRenderState rs, Model model, String part, Cloth cloth, Identifier tex, int light) {
        boolean instant;
        int quality = entity == Minecraft.getInstance().player ? 90 : 45;
        VerletSimulation sim = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.dimension().identifier())), quality, 0.855);
        ModelPartConstraint mpc = new ModelPartConstraint(sim, cloth.rules.getIgnoreParts(), entity, part, model);
        PoseStack ps = new PoseStack();
        mpc.updateEntityTransformation(sim, entity, rs, model, 1.0f);
        ps.mulPose((Matrix4fc)mpc.getEntityTransformation());
        mpc.modelPartTransformation(ps.last().pose());
        Matrix4d xf = new Matrix4d((Matrix4fc)ps.last().pose());
        sim.getConstraints().clear();
        sim.addConstraint(new OceanPhysicsDisplacementConstraint((Entity)entity));
        sim.addConstraint(mpc);
        sim.addConstraint(new WorldConstraint((Entity)entity));
        sim.brightness = light;
        sim.addCloth(cloth, tex, xf, false);
        sim.setOffset(new Vector3d(entity.getX(), entity.getY(), entity.getZ()).add((Vector3dc)sim.getOffset()), false);
        sim.setTransformation(xf);
        sim.setBufferTransformation(xf);
        sim.updateOffsets();
        PhysicsWorld world = PhysicsMod.getInstance((Level)level).physicsWorld;
        mpc.initAsyncData(world, sim);
        mpc.changeInstantly = true;
        mpc.updateAfter(0.0, sim);
        sim.downloadData();
        sim.alwaysFetchInstantly = instant = entity == Minecraft.getInstance().player;
        if (instant) {
            world.addVerletSimulation(0, sim);
        } else {
            world.addVerletSimulation(sim);
        }
        return sim;
    }
}

