/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.optifine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.diebuddies.compat.Optifine;
import net.diebuddies.opengl.Data;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.ShaderInjectionLiquids;
import net.diebuddies.physics.ocean.ShaderInjectionOcean;
import net.diebuddies.physics.smoke.ShaderInjectionSmoke;
import net.diebuddies.util.ShaderFixes;
import net.diebuddies.util.ShaderType;
import net.minecraft.client.Camera;
import net.optifine.shaders.Program;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL32C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Pseudo
@Mixin(targets={"net.optifine.shaders.Shaders"}, remap=false)
public class MixinShaders {
    @Inject(at={@At(value="HEAD")}, method={"setupProgram"})
    private static void physicsmod$getCompilingProgram(Program program, String vShaderPath, String gShaderPath, String fShaderPath, CallbackInfo info) {
        Optifine.compilingProgram = program;
    }

    @Inject(at={@At(value="HEAD")}, method={"createCompShader"})
    private static void physicsmod$switchToCompStage(@Coerce Object program, String filename, CallbackInfoReturnable<Integer> info) {
        Optifine.compileStage = ShaderType.COMPUTE;
    }

    @Inject(at={@At(value="HEAD")}, method={"createVertShader"})
    private static void physicsmod$switchToVertStage(@Coerce Object program, String filename, CallbackInfoReturnable<Integer> info) {
        Optifine.compileStage = ShaderType.VERTEX;
    }

    @Inject(at={@At(value="HEAD")}, method={"createGeomShader"})
    private static void physicsmod$switchToGeomStage(@Coerce Object program, String filename, CallbackInfoReturnable<Integer> info) {
        Optifine.compileStage = ShaderType.GEOMETRY;
    }

    @Inject(at={@At(value="HEAD")}, method={"createFragShader"})
    private static void physicsmod$switchToFragStage(@Coerce Object program, String filename, CallbackInfoReturnable<Integer> info) {
        Optifine.compileStage = ShaderType.FRAGMENT;
    }

    @Inject(at={@At(value="RETURN")}, method={"setCameraShadow"})
    private static void physicsmod$setActiveMatrices(PoseStack matrixStack, Camera activeRenderInfo, float partialTicks, CallbackInfo info) {
        Optifine.shadowView.set((Matrix4fc)matrixStack.last().pose());
    }

    @Inject(method={"setupProgram"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexFormat;getElementAttributeNames()Ljava/util/List;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void physicsmod$setupAttributes(Program program, String vShaderPath, String gShaderPath, String fShaderPath, CallbackInfo ci, int vShader, int gShader, int fShader, int programId, VertexFormat vertexFormat) {
        if (program == Optifine.liquidProgram || program == Optifine.liquidShadowProgram) {
            GL32C.glBindAttribLocation((int)programId, (int)Data.LIQUID_LIGHT.getAttribute(), (CharSequence)"physics_light");
            GL32C.glBindAttribLocation((int)programId, (int)Data.LIQUID_POS.getAttribute(), (CharSequence)"physics_offset");
            GL32C.glBindAttribLocation((int)programId, (int)Data.LIQUID_POS_NEW.getAttribute(), (CharSequence)"physics_offsetNew");
            StarterClient.logger.info("binding optifine liquid attributes");
        } else if (program == Optifine.smokeProgram || program == Optifine.smokeShadowProgram) {
            GL32C.glBindAttribLocation((int)programId, (int)Data.SMOKE_LIGHT.getAttribute(), (CharSequence)"physics_light");
            GL32C.glBindAttribLocation((int)programId, (int)Data.SMOKE_POS.getAttribute(), (CharSequence)"physics_offset");
            GL32C.glBindAttribLocation((int)programId, (int)Data.SMOKE_POS_NEW.getAttribute(), (CharSequence)"physics_offsetNew");
            StarterClient.logger.info("binding optifine smoke attributes");
        }
    }

    @ModifyVariable(method={"shaderSource"}, at=@At(value="HEAD"), ordinal=0)
    private static String physicsmod$applyOceanChanges(String code) {
        if (Optifine.compilingProgram == Optifine.oceanProgram || Optifine.compilingProgram == Optifine.oceanShadowProgram) {
            boolean shadow;
            boolean bl = shadow = Optifine.compilingProgram == Optifine.oceanShadowProgram;
            if (code.contains("#define PHYSICS_OCEAN_SUPPORT")) {
                code = StringUtils.replace((String)code, (String)"#define PHYSICS_OCEAN_SUPPORT", (String)"#define PHYSICS_OCEAN");
                return code;
            }
            if (code.contains("#define PHYSICS_OCEAN_INJECTION")) {
                code = StringUtils.replace((String)code, (String)"#define PHYSICS_OCEAN_INJECTION", (String)"#define PHYSICS_OCEAN");
            }
            if (Optifine.compileStage == ShaderType.VERTEX) {
                code = ShaderFixes.preprocessOptifineSource(code);
                code = ShaderInjectionOcean.getVertexSource(code);
            } else if (Optifine.compileStage == ShaderType.FRAGMENT) {
                code = ShaderFixes.preprocessOptifineSource(code);
                code = ShaderInjectionOcean.getFragmentSource(code, shadow);
            }
        } else if (Optifine.compilingProgram == Optifine.liquidProgram || Optifine.compilingProgram == Optifine.liquidShadowProgram) {
            boolean shadow;
            boolean bl = shadow = Optifine.compilingProgram == Optifine.liquidShadowProgram;
            if (Optifine.compileStage == ShaderType.VERTEX) {
                code = ShaderFixes.preprocessOptifineSource(code);
                code = shadow ? ShaderInjectionLiquids.getVertexShadowSource(code) : ShaderInjectionLiquids.getVertexSource(code);
            } else if (Optifine.compileStage == ShaderType.FRAGMENT) {
                code = ShaderFixes.preprocessOptifineSource(code);
                code = shadow ? ShaderInjectionLiquids.getFragmentShadowSource(code) : ShaderInjectionLiquids.getFragmentSource(code);
            }
        } else if (Optifine.compilingProgram == Optifine.smokeProgram || Optifine.compilingProgram == Optifine.smokeShadowProgram) {
            boolean shadow;
            boolean bl = shadow = Optifine.compilingProgram == Optifine.smokeShadowProgram;
            if (Optifine.compileStage == ShaderType.VERTEX) {
                code = ShaderFixes.preprocessOptifineSource(code);
                code = shadow ? ShaderInjectionSmoke.getVertexShadowSource(code) : ShaderInjectionSmoke.getVertexSource(code);
            } else if (Optifine.compileStage == ShaderType.FRAGMENT) {
                code = ShaderFixes.preprocessOptifineSource(code);
                code = shadow ? ShaderInjectionSmoke.getFragmentShadowSource(code) : ShaderInjectionSmoke.getFragmentSource(code);
            }
        }
        return code;
    }
}

