/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.render;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.diebuddies.compat.Sodium;
import net.diebuddies.opengl.TextureHelper;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.render.BlockEntityVertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;

public class BlockEntityBufferSource
extends MultiBufferSource.BufferSource {
    public static BlockEntityVertexConsumer currentConsumer;
    private Map<RenderType, BlockEntityVertexConsumer> renderTypes = new Object2ObjectOpenHashMap();

    public BlockEntityBufferSource() {
        super(null, new LinkedHashMap());
    }

    public VertexConsumer getBuffer(RenderType layer) {
        RenderSetup.TextureAndSampler textureAndSampler = (RenderSetup.TextureAndSampler)layer.state.getTextures().get("Sampler0");
        GpuTextureView texture = textureAndSampler.textureView();
        TextureHelper.setLoadedTexture(texture);
        currentConsumer = this.renderTypes.computeIfAbsent(layer, key -> StarterClient.sodium ? Sodium.getNewBlockConsumer(texture) : new BlockEntityVertexConsumer(texture));
        return currentConsumer;
    }

    public Map<RenderType, BlockEntityVertexConsumer> getBakedRenderTypeModels() {
        return this.renderTypes;
    }

    public void endLastBatch() {
    }

    public void endBatch() {
    }

    public void endBatch(RenderType renderType) {
    }
}

