/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.PopupWidget;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsSubScreen;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Util;

public class LiquidSettingsScreen
extends LegacyOptionsSubScreen {
    private LegacyOptionsList list;
    private static final CycleOption<Boolean> PHYSICS_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.liquidphysics", gameOptions -> ConfigClient.liquidPhysics, (gameOptions, option, value) -> {
        ConfigClient.liquidPhysics = value;
        ConfigClient.save();
        if (!ConfigClient.liquidPhysics) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
                for (Liquid liquid : liquids) {
                    mod.getPhysicsWorld().removeLiquid(liquid);
                }
            }
        }
    });
    private final CycleOption<Boolean> PHYSICS_CUDA_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.cudaliquids", gameOptions -> ConfigClient.cudaLiquids, (gameOptions, option, value) -> {
        if (((CycleOption)option).active) {
            ConfigClient.cudaLiquids = value;
            ConfigClient.save();
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().destroy();
            }
            PhysicsMod.getInstances().clear();
            StarterClient.createPhysicsCooking(ConfigClient.useCuda());
            this.list.children().clear();
            Minecraft.getInstance().setScreen((Screen)new LiquidSettingsScreen(this.lastScreen, this.options));
        }
    }).setTooltip(minecraft -> graphicsStatus -> {
        if (!StarterClient.cudaAvailable) {
            return Component.translatable((String)"physicsmod.menu.liquid.cudaliquids.error");
        }
        return Component.translatable((String)"physicsmod.menu.liquid.cudaliquids.info");
    });
    private static final ProgressOption PHYSICS_LIQUID_PARTICLE_SIZE = new ProgressOption("physicsmod.menu.liquid.size", 0.05, 0.5, 0.01f, gameOptions -> ConfigClient.liquidParticleSize, (gameOptions, value) -> {
        ConfigClient.liquidParticleSize = value.floatValue();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().destroy();
        }
        PhysicsMod.getInstances().clear();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.size", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.translatable((String)"physicsmod.menu.liquid.size.info"));
    private static final ProgressOption PHYSICS_LIQUID_AMOUNT = new ProgressOption("physicsmod.menu.liquid.amount", 1.0, 64.0, 1.0f, gameOptions -> ConfigClient.liquidAmount, (gameOptions, value) -> {
        ConfigClient.liquidAmount = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.amount", Integer.toString((int)option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIQUID_MAX_PARTICLES = new ProgressOption("physicsmod.menu.liquid.maxpersource", 1.0, 200000.0, 1.0f, gameOptions -> ConfigClient.liquidMaxParticles, (gameOptions, value) -> {
        ConfigClient.liquidMaxParticles = Math.max(value.intValue(), 1);
        ConfigClient.save();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
            for (Liquid liquid : liquids) {
                mod.getPhysicsWorld().removeLiquid(liquid);
            }
        }
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.maxpersource", Integer.toString((int)option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_CUDA_LIQUID_PARTICLE_SIZE = new ProgressOption("physicsmod.menu.liquid.size", 0.05, 0.5, 0.01f, gameOptions -> ConfigClient.cudaLiquidsParticleSize, (gameOptions, value) -> {
        ConfigClient.cudaLiquidsParticleSize = value.floatValue();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().destroy();
        }
        PhysicsMod.getInstances().clear();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.size", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> Component.translatable((String)"physicsmod.menu.liquid.size.info"));
    private static final ProgressOption PHYSICS_CUDA_LIQUID_AMOUNT = new ProgressOption("physicsmod.menu.liquid.amount", 1.0, 64.0, 1.0f, gameOptions -> ConfigClient.liquidCudaAmount, (gameOptions, value) -> {
        ConfigClient.liquidCudaAmount = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.amount", Integer.toString((int)option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_CUDA_LIQUID_MAX_PARTICLES = new ProgressOption("physicsmod.menu.liquid.maxpersource", 1.0, 200000.0, 1.0f, gameOptions -> ConfigClient.liquidCudaMaxParticles, (gameOptions, value) -> {
        ConfigClient.liquidCudaMaxParticles = Math.max(value.intValue(), 1);
        ConfigClient.save();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
            for (Liquid liquid : liquids) {
                mod.getPhysicsWorld().removeLiquid(liquid);
            }
        }
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.maxpersource", Integer.toString((int)option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_CUDA_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquidsCuda, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquidsCuda = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_CUDA_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquidsCuda, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquidsCuda = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((Options)gameOptions))));
    private static final int MAX_INFO_WIDTH = 300;
    private List<FormattedCharSequence> info;

    public LiquidSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.translatable((String)"physicsmod.menu.liquid.title"));
        this.info = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)"physicsmod.menu.liquid.warning"), 300);
    }

    protected void init() {
        this.list = new LegacyOptionsList(this, this.minecraft, this.width, this.height, 32, this.height - 32, 25){

            @Override
            protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
                int yOffset = 137;
                if (ConfigClient.cudaLiquids()) {
                    yOffset = 137;
                }
                super.renderDecorations(guiGraphics, mouseX, mouseY);
            }
        };
        this.children.add(this.list);
        this.addRenderableWidget((GuiEventListener)ButtonSettings.builder(this.width / 2 - 80, this.height - 27, 75, 20, (Component)Component.translatable((String)"physicsmod.gui.pro"), button -> Util.getPlatform().openUri("https://minecraftphysicsmod.com/pro")));
        this.addRenderableWidget((GuiEventListener)ButtonSettings.builder(this.width / 2 + 5, this.height - 27, 75, 20, CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.lastScreen)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.list.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, -1);
        super.render(guiGraphics, mouseX, mouseY, delta);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    @Override
    public void onClose() {
        ConfigClient.save();
        super.onClose();
    }

    private /* synthetic */ void lambda$init$44(Button button) {
        PopupWidget.create(Language.getInstance().getOrDefault("physicsmod.menu.liquid.reset"), this, widget -> this.addRenderableWidget((GuiEventListener)widget), widget -> this.removeWidget((GuiEventListener)widget), response -> {
            if (response == PopupWidget.PopupResponse.YES) {
                ConfigClient.resetLiquidSettings();
                for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                    mod.getPhysicsWorld().destroy();
                }
                PhysicsMod.getInstances().clear();
                this.list.children().clear();
                this.minecraft.setScreen((Screen)new LiquidSettingsScreen(this.lastScreen, this.options));
            } else {
                this.list.children().clear();
                this.minecraft.setScreen((Screen)new LiquidSettingsScreen(this.lastScreen, this.options));
            }
        });
    }

    private /* synthetic */ void lambda$init$40(Button button) {
        this.onClose();
        this.minecraft.setScreen(this.lastScreen);
    }
}

