/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import javax.annotation.Nullable;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.verlet.ClothRules;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;

public class Cloth
implements Comparable<Cloth> {
    public final String name;
    public final ColladaMesh mesh;
    private final Identifier texture;
    private final GpuSampler sampler;
    public final ClothRules rules;
    public final VAO vao;
    public final VAO vaoFlatShaded;
    public final ColladaMesh playerMesh;
    public final VAO playerVAO;

    public Cloth(String name, ColladaMesh mesh, @Nullable ColladaMesh playerMesh, Identifier texture, ClothRules rules) {
        this.name = name;
        this.mesh = mesh;
        this.texture = texture;
        this.sampler = RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST, false);
        this.rules = rules;
        this.vao = mesh.createVAO(false);
        this.vaoFlatShaded = mesh.createVAO(true);
        this.playerMesh = playerMesh;
        this.playerVAO = playerMesh != null ? playerMesh.createVAO(true) : null;
    }

    public Identifier getTexture(@Nullable Entity entity) {
        String specialTexture = this.rules.getSpecialTexture();
        if (specialTexture != null) {
            if (specialTexture.equals("minecraft:playerskin")) {
                if (entity != null && entity instanceof AbstractClientPlayer) {
                    AbstractClientPlayer player = (AbstractClientPlayer)entity;
                    return player.getSkin().body().texturePath();
                }
                return null;
            }
            return Identifier.parse((String)specialTexture);
        }
        return this.texture;
    }

    public GpuTextureView getTextureView(@Nullable Entity entity) {
        Identifier identifier = this.getTexture(entity);
        if (identifier == null) {
            return null;
        }
        return Minecraft.getInstance().getTextureManager().getTexture(identifier).getTextureView();
    }

    public GpuSampler getSampler() {
        return this.sampler;
    }

    public void destroy() {
        if (this.vao != null) {
            this.vao.destroy();
        }
        if (this.vaoFlatShaded != null) {
            this.vaoFlatShaded.destroy();
        }
        if (this.playerVAO != null) {
            this.playerVAO.destroy();
        }
        if (this.texture != null) {
            Minecraft.getInstance().getTextureManager().release(this.texture);
        }
    }

    @Override
    public int compareTo(Cloth o) {
        return this.name.compareTo(o.name);
    }
}

