/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.object.banner.BannerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class BannerConstraint
implements VerletConstraint {
    private List<ModelCube> partsToCheck;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4d invTransformation = new Matrix4d();
    private VerletHelper helper = new VerletHelper();
    private Vector3d invPoint = new Vector3d();
    private Vector2f[] tmpUV;
    private Matrix4f[] textureMatrices;
    private BannerPatternLayers patterns;
    private DyeColor baseColor;
    private MaterialSet materialSet;
    private BlockPos blockPos;
    private BlockState blockState;

    public BannerConstraint(VerletSimulation simulation, BannerModel bannerModel, BannerPatternLayers patterns, DyeColor baseColor, BlockPos pos, BlockState state, MaterialSet materialSet) {
        int i;
        this.materialSet = materialSet;
        this.patterns = patterns;
        this.baseColor = baseColor;
        this.blockPos = pos;
        this.blockState = state;
        List<VerletConstraint> constraints = simulation.getConstraints();
        for (int i2 = 0; i2 < constraints.size(); ++i2) {
            if (!(constraints.get(i2) instanceof RenderConstraint)) continue;
            constraints.remove(i2--);
        }
        this.partsToCheck = new ObjectArrayList();
        bannerModel.allParts().forEach(part -> this.partsToCheck.add(new ModelCube((ModelPart)part)));
        this.calculateTransformation(simulation, 1.0f);
        int capeXPoints = 9;
        int capeYPoints = 17;
        double distance = 0.15000000001500002;
        VerletPoint[][] points = new VerletPoint[capeXPoints][capeYPoints];
        float uvXOff = 0.015625f;
        float uvYOff = 0.015625f;
        float uvXMod = 0.3125f;
        float uvYMod = 0.625f;
        for (int y = 0; y < points[0].length; ++y) {
            for (int x = 0; x < points.length; ++x) {
                Vector3d position = new Vector3d((double)x * distance - (double)capeXPoints * 0.5 * distance + distance * 0.5, (double)y * distance, -0.08928571428571429);
                this.transformation.transformPosition(position);
                VerletPoint point = new VerletPoint(position);
                point.uv.set((float)x / (float)(points.length - 1) * uvXMod + uvXOff, (float)y / (float)(points[0].length - 1) * uvYMod + uvYOff);
                if (y == 0) {
                    point.locked = true;
                }
                points[x][y] = point;
                simulation.addPoint(points[x][y]);
            }
        }
        for (int x = 0; x < points.length; ++x) {
            for (int y = 0; y < points[0].length; ++y) {
                if (x < points.length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x + 1][y]));
                }
                if (y < points[0].length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x][y + 1]));
                }
                if (x >= points.length - 1 || y >= points[0].length - 1) continue;
                simulation.addQuad(new VerletQuad(points[x][y + 1], points[x + 1][y + 1], points[x + 1][y], points[x][y]));
                simulation.addStick(new VerletStick(points[x][y], points[x + 1][y + 1]));
                simulation.addStick(new VerletStick(points[x + 1][y], points[x][y + 1]));
            }
        }
        simulation.calculateNormals();
        simulation.downloadData();
        this.calculateTransformation(simulation, 1.0f);
        List<VerletQuad> quads = simulation.getQuads();
        int drawCalls = java.lang.Math.min(17, patterns.layers().size() + 1);
        int size = quads.size();
        this.tmpUV = new Vector2f[drawCalls * size * 4];
        this.textureMatrices = new Matrix4f[drawCalls];
        for (i = 0; i < this.tmpUV.length; ++i) {
            this.tmpUV[i] = new Vector2f();
        }
        for (i = 0; i < 17 && i < patterns.layers().size() + 1; ++i) {
            Material bannerMaterial = null;
            if (i == 0) {
                bannerMaterial = Sheets.BANNER_BASE;
            } else {
                BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)patterns.layers().get(i - 1);
                bannerMaterial = Sheets.getBannerMaterial((Holder)layer.pattern());
            }
            if (bannerMaterial == null) {
                this.textureMatrices[i] = new Matrix4f();
                continue;
            }
            TextureAtlasSprite sprite = materialSet.get(bannerMaterial);
            float minU = sprite.getU0();
            float maxU = sprite.getU1();
            float minV = sprite.getV0();
            float maxV = sprite.getV1();
            float xScale = maxU - minU;
            float yScale = maxV - minV;
            this.textureMatrices[i] = new Matrix4f().translate(minU, minV, 0.0f).scale(xScale, yScale, 0.0f);
            for (int j = 0; j < quads.size(); ++j) {
                VerletQuad quad = quads.get(j);
                this.remap(quad.point1.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4]);
                this.remap(quad.point2.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 1]);
                this.remap(quad.point3.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 2]);
                this.remap(quad.point4.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 3]);
            }
        }
    }

    private void calculateTransformation(VerletSimulation simulation, float tickDelta) {
        Vector3d offset = simulation.getOffset();
        Matrix4d test = new Matrix4d();
        if (offset != null) {
            test.translate((double)this.blockPos.getX() - offset.x, (double)this.blockPos.getY() - offset.y, (double)this.blockPos.getZ() - offset.z);
        } else {
            test.translate((double)this.blockPos.getX(), (double)this.blockPos.getY(), (double)this.blockPos.getZ());
        }
        if (this.blockState.getBlock() instanceof BannerBlock) {
            test.translate(0.5, 0.5, 0.5);
            blockRotation = (float)(-((Integer)this.blockState.getValue((Property)BannerBlock.ROTATION)).intValue() * 360) / 16.0f;
            test.rotate((Quaternionfc)Axis.YP.rotationDegrees(blockRotation));
        } else {
            test.translate(0.5, -0.1666666716337204, 0.5);
            blockRotation = -((Direction)this.blockState.getValue((Property)WallBannerBlock.FACING)).toYRot();
            test.rotate((Quaternionfc)Axis.YP.rotationDegrees(blockRotation));
            test.translate(0.0, -0.3125, -0.4375);
        }
        test.scale(0.6666667, -0.6666667, -0.6666667);
        if (simulation.getOffset() == null) {
            long gameTime = 0L;
            float n = ((float)java.lang.Math.floorMod((long)(this.blockPos.getX() * 7 + this.blockPos.getY() * 9 + this.blockPos.getZ() * 13) + gameTime, 100L) + tickDelta) / 100.0f;
            float xRot = (-0.0125f + 0.01f * Mth.cos((double)((float)java.lang.Math.PI * 2 * n))) * (float)java.lang.Math.PI;
            double yPos = -32.0;
            test.translate(0.0, yPos / 16.0, 0.0);
            if (xRot != 0.0f) {
                test.rotate((Quaternionfc)Axis.XP.rotation(xRot));
            }
        }
        this.transformation.set((Matrix4dc)test);
        this.transformation.invert(this.invTransformation);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        for (int i = 0; i < this.partsToCheck.size(); ++i) {
            ModelCube cube = this.partsToCheck.get(i);
            cube.pose = cube.part.storePose();
            cube.updateHitbox();
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        this.doCollisionCheck(percent, simulation);
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
    }

    public void translateAndRotate(PoseStack poseStack, PartPose pose) {
        poseStack.translate((double)pose.x() / 16.0, (double)pose.y() / 16.0, (double)pose.z() / 16.0);
        if (pose.zRot() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(pose.zRot()));
        }
        if (pose.yRot() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation(pose.yRot()));
        }
        if (pose.xRot() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotation(pose.xRot()));
        }
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double renderPercent, VerletSimulation simulation) {
        int brightness = simulation.brightness;
        List<VerletQuad> quads = simulation.getQuads();
        int size = quads.size();
        float[] color = new float[4];
        if (simulation.getQuads().size() > 0) {
            List<VerletPoint> points = simulation.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                points.get(i).updateRenderPosition(renderPercent);
            }
            MultiBufferSource.BufferSource buffer = MainRenderer.bufferSource;
            for (int i = 0; i < 17 && i < this.patterns.layers().size() + 1; ++i) {
                Material bannerMaterial;
                int icolor;
                if (i == 0) {
                    icolor = this.baseColor.getTextureDiffuseColor();
                    bannerMaterial = Sheets.BANNER_BASE;
                } else {
                    BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)this.patterns.layers().get(i - 1);
                    icolor = layer.color().getTextureDiffuseColor();
                    bannerMaterial = Sheets.getBannerMaterial((Holder)layer.pattern());
                }
                color[0] = (float)ARGB.red((int)icolor) / 255.0f;
                color[1] = (float)ARGB.green((int)icolor) / 255.0f;
                color[2] = (float)ARGB.blue((int)icolor) / 255.0f;
                color[3] = (float)ARGB.alpha((int)icolor) / 255.0f;
                if (bannerMaterial == null) continue;
                TextureAtlasSprite sprite = this.materialSet.get(bannerMaterial);
                int drawCallIndex = i * size * 4;
                RenderType renderType = StarterClient.iris && Iris.isExtending() ? (i == 0 ? PhysicsShaders.PHYSICS_CLOTH_RENDER_IRIS.apply(sprite.atlasLocation()) : PhysicsShaders.PHYSICS_BANNER_RENDER_IRIS.apply(sprite.atlasLocation())) : PhysicsShaders.PHYSICS_BANNER_RENDER.apply(sprite.atlasLocation());
                VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
                for (int j = 0; j < quads.size(); ++j) {
                    VerletQuad quad = quads.get(j);
                    int multiple = j * 4;
                    int uvIndex = drawCallIndex + multiple;
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.point1.bufferNormal, brightness, color);
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.point3.bufferNormal, brightness, color);
                        this.bufferVertex(vertexConsumer, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                        continue;
                    }
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.bufferNormal, brightness, color);
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.bufferNormal, brightness, color);
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.bufferNormal, brightness, color);
                    this.bufferVertex(vertexConsumer, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.bufferNormal, brightness, color);
                }
            }
            buffer.endBatch();
        }
    }

    private void remap(Vector2f uv, float minU, float maxU, float minV, float maxV, Vector2f dst) {
        dst.set(Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV));
    }

    private void bufferVertex(VertexConsumer bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, float[] color) {
        bufferbuilder.addVertex((float)position.x, (float)position.y, (float)position.z).setColor(color[0], color[1], color[2], 1.0f).setUv(uv.x, uv.y).setOverlay(OverlayTexture.NO_OVERLAY).setLight(brightness).setNormal((float)normal.x, (float)normal.y, (float)normal.z);
    }
}

